/*
 * Decompiled with CFR 0.152.
 */
package uqmnamegen.generators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameGenerator {
    public ArrayList<String> vowels;
    public ArrayList<String> consonants;
    public ArrayList<String> stops;
    public ArrayList<String> affricates;
    public ArrayList<String> fricatives;
    public ArrayList<String> nasals;
    public ArrayList<String> liquids;
    public ArrayList<String> glides;
    public ArrayList<String> remainingConsonants;
    public ArrayList<String> namepatterns;
    public int maxcombolength = -1;
    public HashMap<ArrayList<String>, String> patchars = new HashMap();
    public HashMap<ArrayList<String>, String> patnames = new HashMap();
    static Random RANDOM = new Random();

    public NameGenerator() {
        this.vowels = new ArrayList();
        this.vowels.add("a");
        this.vowels.add("e");
        this.vowels.add("i");
        this.vowels.add("o");
        this.vowels.add("u");
        this.vowels.add("y");
        this.consonants = new ArrayList();
        this.consonants.add("b");
        this.consonants.add("c");
        this.consonants.add("d");
        this.consonants.add("f");
        this.consonants.add("g");
        this.consonants.add("h");
        this.consonants.add("j");
        this.consonants.add("k");
        this.consonants.add("l");
        this.consonants.add("m");
        this.consonants.add("n");
        this.consonants.add("p");
        this.consonants.add("q");
        this.consonants.add("r");
        this.consonants.add("s");
        this.consonants.add("t");
        this.consonants.add("v");
        this.consonants.add("x");
        this.consonants.add("z");
        this.consonants.add("w");
        this.stops = new ArrayList();
        this.stops.add("p");
        this.stops.add("t");
        this.stops.add("k");
        this.stops.add("b");
        this.stops.add("d");
        this.stops.add("c");
        this.stops.add("ck");
        this.affricates = new ArrayList();
        this.affricates.add("j");
        this.affricates.add("g");
        this.affricates.add("ch");
        this.affricates.add("dz");
        this.affricates.add("ds");
        this.affricates.add("ts");
        this.affricates.add("tch");
        this.affricates.add("tu");
        this.affricates.add("dg");
        this.fricatives = new ArrayList();
        this.fricatives.add("f");
        this.fricatives.add("gh");
        this.fricatives.add("v");
        this.fricatives.add("f");
        this.fricatives.add("th");
        this.fricatives.add("s");
        this.fricatives.add("sh");
        this.fricatives.add("ch");
        this.fricatives.add("g");
        this.fricatives.add("h");
        this.nasals = new ArrayList();
        this.nasals.add("m");
        this.nasals.add("n");
        this.nasals.add("kn");
        this.nasals.add("gn");
        this.nasals.add("ng");
        this.liquids = new ArrayList();
        this.liquids.add("l");
        this.liquids.add("le");
        this.liquids.add("r");
        this.liquids.add("er");
        this.liquids.add("ur");
        this.glides = new ArrayList();
        this.glides.add("w");
        this.glides.add("wh");
        this.remainingConsonants = new ArrayList();
        this.remainingConsonants.addAll(this.consonants);
        this.remainingConsonants.removeAll(this.stops);
        this.remainingConsonants.removeAll(this.affricates);
        this.remainingConsonants.removeAll(this.fricatives);
        this.remainingConsonants.removeAll(this.nasals);
        this.remainingConsonants.removeAll(this.liquids);
        this.remainingConsonants.removeAll(this.glides);
        for (String s : this.vowels) {
            if (s.length() <= this.maxcombolength) continue;
            this.maxcombolength = s.length();
        }
        for (String s : this.consonants) {
            if (s.length() <= this.maxcombolength) continue;
            this.maxcombolength = s.length();
        }
        for (String s : this.stops) {
            if (s.length() <= this.maxcombolength) continue;
            this.maxcombolength = s.length();
        }
        for (String s : this.affricates) {
            if (s.length() <= this.maxcombolength) continue;
            this.maxcombolength = s.length();
        }
        for (String s : this.fricatives) {
            if (s.length() <= this.maxcombolength) continue;
            this.maxcombolength = s.length();
        }
        try {
            File f = new File("patterns.txt");
            this.namepatterns = new ArrayList();
            BufferedReader br = new BufferedReader(new FileReader(f));
            while (br.ready()) {
                this.namepatterns.add(br.readLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addpat("vowels", "v", this.vowels);
        this.addpat("consonants", "c", this.consonants);
        this.addpat("stops", "s", this.stops);
        this.addpat("affricates", "a", this.affricates);
        this.addpat("fricatives", "f", this.fricatives);
        this.addpat("nasals", "n", this.nasals);
        this.addpat("liquids", "l", this.liquids);
        this.addpat("glides", "g", this.glides);
        this.addpat("remaining consonants", "r", this.remainingConsonants);
    }

    public String genRandName() {
        return this.genName(this.getRandom(this.namepatterns));
    }

    public void addpat(String name, String character, ArrayList<String> list) {
        this.patchars.put(list, character);
        this.patnames.put(list, name);
    }

    public String genName(String namePattern) {
        int hash = namePattern.indexOf("#");
        if (hash != -1) {
            namePattern = namePattern.substring(0, hash).trim();
        }
        String retstring = "";
        String tempstring = "";
        boolean literal = false;
        block23: for (int i = 0; i < namePattern.length(); ++i) {
            char in = namePattern.charAt(i);
            if (in == '\\' && !literal) {
                literal = true;
                continue;
            }
            if (literal) {
                retstring = retstring + in;
                literal = false;
                continue;
            }
            switch (in) {
                case 'C': {
                    retstring = retstring + this.getRandomU(this.consonants);
                    continue block23;
                }
                case 'c': {
                    retstring = retstring + this.getRandom(this.consonants);
                    continue block23;
                }
                case 'V': {
                    retstring = retstring + this.getRandomU(this.vowels);
                    continue block23;
                }
                case 'v': {
                    retstring = retstring + this.getRandom(this.vowels);
                    continue block23;
                }
                case 'S': {
                    retstring = retstring + this.getRandomU(this.stops);
                    continue block23;
                }
                case 's': {
                    retstring = retstring + this.getRandom(this.stops);
                    continue block23;
                }
                case 'R': {
                    retstring = retstring + this.getRandomU(this.remainingConsonants);
                    continue block23;
                }
                case 'r': {
                    retstring = retstring + this.getRandom(this.remainingConsonants);
                    continue block23;
                }
                case 'A': {
                    retstring = retstring + this.getRandomU(this.affricates);
                    continue block23;
                }
                case 'a': {
                    retstring = retstring + this.getRandom(this.affricates);
                    continue block23;
                }
                case 'F': {
                    retstring = retstring + this.getRandomU(this.fricatives);
                    continue block23;
                }
                case 'f': {
                    retstring = retstring + this.getRandom(this.fricatives);
                    continue block23;
                }
                case 'N': {
                    retstring = retstring + this.getRandomU(this.nasals);
                    continue block23;
                }
                case 'n': {
                    retstring = retstring + this.getRandom(this.nasals);
                    continue block23;
                }
                case 'L': {
                    retstring = retstring + this.getRandomU(this.liquids);
                    continue block23;
                }
                case 'l': {
                    retstring = retstring + this.getRandom(this.liquids);
                    continue block23;
                }
                case 'G': {
                    retstring = retstring + this.getRandomU(this.glides);
                    continue block23;
                }
                case 'g': {
                    retstring = retstring + this.getRandom(this.glides);
                    continue block23;
                }
                case 'U': {
                    retstring = retstring + (RANDOM.nextInt(9) + 1);
                    continue block23;
                }
                case 'u': {
                    retstring = retstring + RANDOM.nextInt(10);
                    continue block23;
                }
                case 'p': {
                    retstring = retstring + retstring.substring(retstring.length() - 1, retstring.length()).toLowerCase();
                }
            }
        }
        return retstring;
    }

    private String getRandom(ArrayList<String> fromList) {
        return fromList.get(RANDOM.nextInt(fromList.size()));
    }

    private String getRandomU(ArrayList<String> fromList) {
        String tempstring = this.getRandom(fromList);
        return tempstring.substring(0, 1).toUpperCase() + tempstring.substring(1, tempstring.length());
    }

    public void analyze(String filein) {
        HashMap<String, Integer> hashmap = new HashMap<String, Integer>();
        HashMap<String, ArrayList<String>> hashmap2 = new HashMap<String, ArrayList<String>>();
        try {
            File f = new File(filein);
            ArrayList retlist = new ArrayList();
            BufferedReader br = new BufferedReader(new FileReader(f));
            while (br.ready()) {
                String process = br.readLine();
                String out = "";
                block3: for (int i = 0; i < process.length(); ++i) {
                    for (int j = this.maxcombolength; j > 0; --j) {
                        if (i + j > process.length()) continue;
                        String chk = process.substring(i, i + j).toLowerCase();
                        if (i > 0 && j == 1 && chk.equals(process.substring(i - 1, i).toLowerCase())) {
                            out = out + "p";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.stops.contains(chk)) {
                            out = out + "s";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.affricates.contains(chk)) {
                            out = out + "a";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.fricatives.contains(chk)) {
                            out = out + "f";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.nasals.contains(chk)) {
                            out = out + "n";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.liquids.contains(chk)) {
                            out = out + "l";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.glides.contains(chk)) {
                            out = out + "g";
                            i += j - 1;
                            continue block3;
                        }
                        if (this.vowels.contains(chk)) {
                            out = out + "v";
                            i += j - 1;
                            continue block3;
                        }
                        if (!this.consonants.contains(chk)) continue;
                        out = out + "r";
                        i += j - 1;
                        continue block3;
                    }
                }
                Integer i = (Integer)hashmap.get(out);
                ArrayList<String> i2 = (ArrayList<String>)hashmap2.get(out);
                if (i == null) {
                    i = 0;
                }
                if (i2 == null) {
                    i2 = new ArrayList<String>();
                }
                i2.add(process);
                hashmap.put(out, i + 1);
                hashmap2.put(out, i2);
            }
            for (String key : NameGenerator.sortByValue(hashmap)) {
                String list = "";
                for (String s : (ArrayList)hashmap2.get(key)) {
                    list = list + "`" + s + "` ";
                }
                System.out.println("" + key + " #:" + hashmap.get(key) + " ---- " + list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List sortByValue(final Map m) {
        ArrayList keys = new ArrayList();
        keys.addAll(m.keySet());
        Collections.sort(keys, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object v1 = m.get(o1);
                Object v2 = m.get(o2);
                if (v1 == null) {
                    return v2 == null ? 0 : 1;
                }
                if (v1 instanceof Comparable) {
                    return ((Comparable)v1).compareTo(v2);
                }
                return 0;
            }
        });
        return keys;
    }
}

