/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MainFrame.java
 *
 * Created on 2-okt-2010, 15:26:29
 */
package uqmdialogtool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uqmdialogtool.dialogue.Dialog_Entry;
import uqmdialogtool.uqmbase.AbstractFile;

/**
 *
 * @author joris
 */
public class MainFrame extends javax.swing.JFrame {

    ArrayList<AbstractFile> combobox_files;
    DefaultListModel dmList_Alien = new DefaultListModel();
    DefaultListModel dmList_Zelnick = new DefaultListModel();
    ArrayList<Dialog_Entry> MasterList = new ArrayList<Dialog_Entry>();
    Dialog_Entry editingEntry;
    Dialog_Entry.E_dialogType editingFromList;
    boolean editingNew = true;
    public static String extra_searchpath;
    private String UQMDIALOGTOOL_VERSION_STRING = "UQMDialogTool v0.5";

    /** Creates new form MainFrame */
    public MainFrame(String extra_searchpath, boolean nobugging) {
        initComponents();
        this.setTitle(UQMDIALOGTOOL_VERSION_STRING);

        this.extra_searchpath = extra_searchpath;

        pnl_Right.setVisible(false);
        pnl_Left_Inner.setVisible(false);
        try {
            refreshCombobox();
        } catch (ZipException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        list_AlienD.setModel(dmList_Alien);
        list_ZelnickD.setModel(dmList_Zelnick);
        cmb_Encounters.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                try {
                    parseDialogfile(combobox_files.get(cmb_Encounters.getSelectedIndex()).getBufferedReader());
                } catch (IOException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                pnl_Left_Inner.setVisible(true);
                btn_Save.setEnabled(true);
                btn_genstringsh.setEnabled(true);
            }
        });


        list_AlienD.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (list_AlienD.getSelectedIndex() != -1) {
                    Dialog_Entry temp = (Dialog_Entry) dmList_Alien.get(list_AlienD.getSelectedIndex());
                    setEditing(temp, Dialog_Entry.E_dialogType.alien, false);

                    list_ZelnickD.clearSelection();
                    list_ZelnickD.updateUI();
                }
            }
        });

        list_ZelnickD.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (list_ZelnickD.getSelectedIndex() != -1) {
                    Dialog_Entry temp = (Dialog_Entry) dmList_Zelnick.get(list_ZelnickD.getSelectedIndex());
                    setEditing(temp, Dialog_Entry.E_dialogType.zelnick, false);

                    list_AlienD.clearSelection();
                    list_AlienD.updateUI();
                }
            }
        });

        if (!nobugging) {
            showHelp(); //Epique annoying-ness! Ohwell.
        }
    }

    public void showHelp() {
        Notes_and_help nah = new Notes_and_help(this, false);
        nah.setVisible(true);
    }

    public void setEditing(Dialog_Entry de, Dialog_Entry.E_dialogType fromList, boolean is_new) {
        pnl_Right.setVisible(true);
        editingEntry = de;
        editingFromList = fromList;
        editingNew = is_new;

        if (editingEntry == null || editingFromList == null) {
            textarea_rp_dialogString.setText("");
            text_rp_filename.setText("");
            text_rp_identifier.setText("");
        } else {
            textarea_rp_dialogString.setText(editingEntry.dialogString);
            text_rp_filename.setText(editingEntry.voiceFilename);
            text_rp_identifier.setText(editingEntry.dialogIdentifier);
        }
    }

    public void saveEntry() {
        if (editingEntry != null && editingFromList != null) {
            if (editingNew && (editingFromList == Dialog_Entry.E_dialogType.alien)) {
                text_rp_identifier.setText(text_rp_identifier.getText().toUpperCase()); //Force uppercase to prevent people from making mistakes
            }

            editingEntry.modified = true;
            editingEntry.dialogIdentifier = text_rp_identifier.getText();
            editingEntry.dialogString = textarea_rp_dialogString.getText();
            editingEntry.voiceFilename = text_rp_filename.getText();
            editingEntry.finalize_init();
            editingEntry.type = editingFromList;

            if (editingNew) {
                if (editingFromList == Dialog_Entry.E_dialogType.alien) {
                    MasterList.add(editingEntry);
                    dmList_Alien.addElement(editingEntry);
                    list_AlienD.setSelectedIndex(dmList_Alien.size() - 1);
                    list_AlienD.updateUI();
                } else if (editingFromList == Dialog_Entry.E_dialogType.zelnick) {
                    MasterList.add(editingEntry);
                    dmList_Zelnick.addElement(editingEntry);
                    list_ZelnickD.setSelectedIndex(dmList_Zelnick.size() - 1);
                    list_ZelnickD.updateUI();
                }
            } else {
                if (editingFromList == Dialog_Entry.E_dialogType.alien) {
                    dmList_Alien.set(list_AlienD.getSelectedIndex(), editingEntry);
                } else if (editingFromList == Dialog_Entry.E_dialogType.zelnick) {
                    dmList_Zelnick.set(list_ZelnickD.getSelectedIndex(), editingEntry);
                }
            }
        }
    }

    private AbstractFile saveDialogFile() {
        AbstractFile retabsf = null;

        FileWriter fw = null;
        try {
            File f = combobox_files.get(cmb_Encounters.getSelectedIndex()).getFile();
            fw = new FileWriter(f);
            if (combobox_files.get(cmb_Encounters.getSelectedIndex()).ftype == AbstractFile.FileType.inzipfile) {
                retabsf = new AbstractFile(f);
            }
            for (Dialog_Entry temp : MasterList) {
                temp.modified = false;
                fw.write(temp.render());
                fw.write("\r\n\r\n");
            }
        } catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                fw.close();
            } catch (IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        list_AlienD.clearSelection();
        list_ZelnickD.clearSelection();
        list_AlienD.updateUI();
        list_ZelnickD.updateUI();

        return retabsf;
    }

    public void refreshComboBox_parseDir(String dirStr, String header) throws IOException {
        File dir = new File(dirStr);  //TODO: fix this. :)

        File[] files = dir.listFiles();
        ArrayList<File> dialogfiles = new ArrayList<File>();
        if (files == null) {
            //
        } else {
            for (File file : files) {
                // Get filename of file or directory
                if (file.isDirectory()) {
                    File[] textfiles = file.listFiles(new FilenameFilter() {

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".txt");
                        }
                    });
                    dialogfiles.addAll(Arrays.asList(textfiles));
                }
            }
        }

        for (File dialogfile : dialogfiles) {
            AbstractFile abs = new AbstractFile(dialogfile);
            abs.fheader = header;
            cmb_Encounters.addItem(abs);
            combobox_files.add(abs);
        }
    }

    public void refreshComboBos_parseUQM(String packagesDirStr) throws ZipException, IOException {
        File packagesdir = new File(packagesDirStr);
        if (packagesdir.exists()) {
            File[] uqmfiles = packagesdir.listFiles(new FilenameFilter() {

                public boolean accept(File dir, String name) {
                    return name.endsWith(".uqm");
                }
            });
            for (File uqmfile : uqmfiles) {
                ZipFile zipfile = new ZipFile(uqmfile);
                Enumeration e = zipfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry) e.nextElement();
                    if (entry.getName().matches(".*/?comm/\\S*/\\S*\\.txt") || entry.getName().matches(extra_searchpath + "/comm/\\S*/\\S*\\.txt")) {
                        AbstractFile abs = new AbstractFile(zipfile, entry);
                        cmb_Encounters.addItem(abs);
                        combobox_files.add(abs);
                    }
                }
            }
        }
    }

    public void refreshCombobox() throws ZipException, IOException {
        combobox_files = new ArrayList<AbstractFile>();
        cmb_Encounters.removeAllItems();

        refreshComboBox_parseDir("content\\comm", "");
        if (!extra_searchpath.equals("")) {
            refreshComboBox_parseDir("content\\" + extra_searchpath + "\\comm", extra_searchpath.toUpperCase());
        }

        refreshComboBos_parseUQM("content\\packages");
    }

    public void parseDialogfile(BufferedReader in) {
        try {
            dmList_Alien.removeAllElements();
            dmList_Zelnick.removeAllElements();
            list_AlienD.removeAll();
            list_ZelnickD.removeAll();
            MasterList.clear();

            boolean parsing = false;
            Dialog_Entry workingEntry = null;
            while (in.ready()) {
                String readline = in.readLine();
                //System.err.println(readline);
                if (readline.startsWith("#(")) {
                    if (parsing) {
                        parsing = false;
                        workingEntry.finalize_init();
                        if (workingEntry.type == Dialog_Entry.E_dialogType.alien) {
                            MasterList.add(workingEntry);
                        } else if (workingEntry.type == Dialog_Entry.E_dialogType.zelnick) {
                            MasterList.add(workingEntry);
                        }
                    }

                    parsing = true;
                    String[] splitted = readline.split("\\s");
                    if (splitted.length >= 1) {
                        workingEntry = new Dialog_Entry();
                        workingEntry.dialogIdentifier = splitted[0].replace("#(", "").replace(")", "");
                    }
                    if (splitted.length >= 2) {
                        workingEntry.voiceFilename = splitted[1];
                    } else {
                        workingEntry.voiceFilename = "";
                    }
                } else if (readline.equals("") && parsing) {
                    parsing = false;
                    workingEntry.finalize_init();
                    if (workingEntry.type == Dialog_Entry.E_dialogType.alien) {
                        MasterList.add(workingEntry);
                    } else if (workingEntry.type == Dialog_Entry.E_dialogType.zelnick) {
                        MasterList.add(workingEntry);
                    }
                    //System.err.println("Parsing complete -- " + workingEntry);
                    //System.err.println(workingEntry.render());
                } else if (parsing == true) {
                    //System.err.println("Adding: [" + readline + "]");
                    workingEntry.dialogString += readline + "\r\n";
                }
            }
            if (parsing) {
                parsing = false;
                workingEntry.finalize_init();
                if (workingEntry.type == Dialog_Entry.E_dialogType.alien) {
                    MasterList.add(workingEntry);
                } else if (workingEntry.type == Dialog_Entry.E_dialogType.zelnick) {
                    MasterList.add(workingEntry);
                }
            }
            for (Dialog_Entry de : MasterList) {
                if (de.type == Dialog_Entry.E_dialogType.alien) {
                    dmList_Alien.addElement(de);
                } else if (de.type == Dialog_Entry.E_dialogType.zelnick) {
                    dmList_Zelnick.addElement(de);
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public void generateStringsH() {
        String temp = "//Copyright Paul Reiche, Fred Ford. 1992-2002\n"
                + "//This file was generated by " + UQMDIALOGTOOL_VERSION_STRING + "\n"
                + "\n"
                + "/*\n"
                + "*  This program is free software; you can redistribute it and/or modify\n"
                + "*  it under the terms of the GNU General Public License as published by\n"
                + "*  the Free Software Foundation; either version 2 of the License, or\n"
                + "*  (at your option) any later version.\n"
                + "*\n"
                + "*  This program is distributed in the hope that it will be useful,\n"
                + "*  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
                + "*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
                + "*  GNU General Public License for more details.\n"
                + "*\n"
                + "*  You should have received a copy of the GNU General Public License\n"
                + "*  along with this program; if not, write to the Free Software\n"
                + "*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n"
                + "*/\n"
                + "\n"
                + "#ifndef _STRINGS_H\n"
                + "#define _STRINGS_H\n"
                + "\n"
                + "enum\n{\n";

        int num = MasterList.size();
        for (Dialog_Entry de : MasterList) {
            if (num > 1) {
                temp += "\t" + de.dialogIdentifier + ",\n";
            } else {
                temp += "\t" + de.dialogIdentifier + "\n";
            }
            num--;
        }
        temp += "};\n"
                + "\n"
                + "#endif /* _STRINGS_H */\n\n";
        new StringsH(this, true, temp).setVisible(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnl_Left = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        cmb_Encounters = new javax.swing.JComboBox();
        pnl_Left_Inner = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        list_AlienD = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        list_ZelnickD = new javax.swing.JList();
        bt_lp_newAlien = new javax.swing.JButton();
        bt_lp_newZelnick = new javax.swing.JButton();
        btn_Save = new javax.swing.JButton();
        btn_Help = new javax.swing.JButton();
        btn_genstringsh = new javax.swing.JButton();
        pnl_Right = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        textarea_rp_dialogString = new javax.swing.JTextArea();
        btn_rp_Save = new javax.swing.JButton();
        btn_rp_Cancel = new javax.swing.JButton();
        text_rp_identifier = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        text_rp_filename = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("UQMDialogTool");

        pnl_Left.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        pnl_Left.setPreferredSize(new java.awt.Dimension(375, 677));

        jLabel1.setText("Encounter (Alien):");

        cmb_Encounters.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        pnl_Left_Inner.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        jLabel2.setText("Alien Dialogue:");

        jLabel3.setText("Zelnick Dialogue:");

        list_AlienD.setFont(new java.awt.Font("Lucida Console", 0, 11)); // NOI18N
        list_AlienD.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(list_AlienD);

        list_ZelnickD.setFont(new java.awt.Font("Lucida Console", 0, 11));
        list_ZelnickD.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane2.setViewportView(list_ZelnickD);

        bt_lp_newAlien.setText("New entry");
        bt_lp_newAlien.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bt_lp_newAlienActionPerformed(evt);
            }
        });

        bt_lp_newZelnick.setText("New entry");
        bt_lp_newZelnick.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bt_lp_newZelnickActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnl_Left_InnerLayout = new javax.swing.GroupLayout(pnl_Left_Inner);
        pnl_Left_Inner.setLayout(pnl_Left_InnerLayout);
        pnl_Left_InnerLayout.setHorizontalGroup(
            pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_Left_InnerLayout.createSequentialGroup()
                .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnl_Left_InnerLayout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 165, Short.MAX_VALUE)
                        .addComponent(bt_lp_newZelnick))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnl_Left_InnerLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 329, Short.MAX_VALUE)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 329, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, pnl_Left_InnerLayout.createSequentialGroup()
                                .addComponent(jLabel2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 175, Short.MAX_VALUE)
                                .addComponent(bt_lp_newAlien)))))
                .addContainerGap())
        );
        pnl_Left_InnerLayout.setVerticalGroup(
            pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_Left_InnerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(bt_lp_newAlien))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 273, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(bt_lp_newZelnick))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 214, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        btn_Save.setText("Save");
        btn_Save.setEnabled(false);
        btn_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_SaveActionPerformed(evt);
            }
        });

        btn_Help.setText("Help!");
        btn_Help.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_HelpActionPerformed(evt);
            }
        });

        btn_genstringsh.setText("generate strings.h");
        btn_genstringsh.setEnabled(false);
        btn_genstringsh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_genstringshActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnl_LeftLayout = new javax.swing.GroupLayout(pnl_Left);
        pnl_Left.setLayout(pnl_LeftLayout);
        pnl_LeftLayout.setHorizontalGroup(
            pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_LeftLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(cmb_Encounters, 0, 353, Short.MAX_VALUE)
                    .addComponent(pnl_Left_Inner, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnl_LeftLayout.createSequentialGroup()
                        .addComponent(btn_Help)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 112, Short.MAX_VALUE)
                        .addComponent(btn_genstringsh)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btn_Save)))
                .addContainerGap())
        );
        pnl_LeftLayout.setVerticalGroup(
            pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_LeftLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cmb_Encounters, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btn_Save)
                    .addComponent(btn_Help)
                    .addComponent(btn_genstringsh))
                .addGap(7, 7, 7)
                .addComponent(pnl_Left_Inner, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pnl_Right.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        textarea_rp_dialogString.setColumns(20);
        textarea_rp_dialogString.setRows(5);
        jScrollPane3.setViewportView(textarea_rp_dialogString);

        btn_rp_Save.setText("Save");
        btn_rp_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_rp_SaveActionPerformed(evt);
            }
        });

        btn_rp_Cancel.setText("Cancel");
        btn_rp_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_rp_CancelActionPerformed(evt);
            }
        });

        jLabel4.setText("Identifier");

        jLabel5.setText("Voice filename");

        jLabel6.setText("Dialog text:");

        javax.swing.GroupLayout pnl_RightLayout = new javax.swing.GroupLayout(pnl_Right);
        pnl_Right.setLayout(pnl_RightLayout);
        pnl_RightLayout.setHorizontalGroup(
            pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_RightLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 470, Short.MAX_VALUE)
                    .addComponent(jLabel6)
                    .addGroup(pnl_RightLayout.createSequentialGroup()
                        .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel5)
                            .addComponent(jLabel4))
                        .addGap(18, 18, 18)
                        .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(text_rp_identifier, javax.swing.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE)
                            .addComponent(text_rp_filename, javax.swing.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnl_RightLayout.createSequentialGroup()
                        .addComponent(btn_rp_Cancel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 348, Short.MAX_VALUE)
                        .addComponent(btn_rp_Save)))
                .addContainerGap())
        );
        pnl_RightLayout.setVerticalGroup(
            pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_RightLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(text_rp_identifier, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(text_rp_filename, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(21, 21, 21)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 537, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btn_rp_Save)
                    .addComponent(btn_rp_Cancel))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(pnl_Left, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnl_Right, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(pnl_Right, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(pnl_Left, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btn_rp_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_rp_SaveActionPerformed
        saveEntry();
    }//GEN-LAST:event_btn_rp_SaveActionPerformed

    private void btn_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_SaveActionPerformed
        AbstractFile absf = saveDialogFile();
        if (absf != null) {
            cmb_Encounters.addItem(absf);
            combobox_files.add(absf);
            cmb_Encounters.setSelectedIndex(cmb_Encounters.getItemCount() - 1);
            cmb_Encounters.updateUI();
        }
    }//GEN-LAST:event_btn_SaveActionPerformed

    private void btn_rp_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_rp_CancelActionPerformed
        setEditing(null, null, false);
        pnl_Right.setVisible(false);
    }//GEN-LAST:event_btn_rp_CancelActionPerformed

    private void bt_lp_newAlienActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bt_lp_newAlienActionPerformed
        Dialog_Entry temp = new Dialog_Entry();
        temp.type = Dialog_Entry.E_dialogType.alien;
        setEditing(new Dialog_Entry(), Dialog_Entry.E_dialogType.alien, true);
    }//GEN-LAST:event_bt_lp_newAlienActionPerformed

    private void bt_lp_newZelnickActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bt_lp_newZelnickActionPerformed
        Dialog_Entry temp = new Dialog_Entry();
        temp.type = Dialog_Entry.E_dialogType.zelnick;
        setEditing(new Dialog_Entry(), Dialog_Entry.E_dialogType.zelnick, true);
    }//GEN-LAST:event_bt_lp_newZelnickActionPerformed

    private void btn_HelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_HelpActionPerformed
        showHelp();
    }//GEN-LAST:event_btn_HelpActionPerformed

    private void btn_genstringshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_genstringshActionPerformed
        generateStringsH();
    }//GEN-LAST:event_btn_genstringshActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bt_lp_newAlien;
    private javax.swing.JButton bt_lp_newZelnick;
    private javax.swing.JButton btn_Help;
    private javax.swing.JButton btn_Save;
    private javax.swing.JButton btn_genstringsh;
    private javax.swing.JButton btn_rp_Cancel;
    private javax.swing.JButton btn_rp_Save;
    private javax.swing.JComboBox cmb_Encounters;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JList list_AlienD;
    private javax.swing.JList list_ZelnickD;
    private javax.swing.JPanel pnl_Left;
    private javax.swing.JPanel pnl_Left_Inner;
    private javax.swing.JPanel pnl_Right;
    private javax.swing.JTextField text_rp_filename;
    private javax.swing.JTextField text_rp_identifier;
    private javax.swing.JTextArea textarea_rp_dialogString;
    // End of variables declaration//GEN-END:variables
}
