/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.filestuff;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uqmconversation.UQMConversationTool;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.Dialog_Entry;

public class DialogParser {

    public static final int CLEARTYPE_CLEAR = 0;
    public static final int CLEARTYPE_OVERWRITE = 1;
    public static final int CLEARTYPE_NO_OVERWRITE = 2;

    public static int parseDialogfile(BufferedReader in, Conversation convo, int cleartype) {
        try {
            int added = 0;
            if (cleartype == CLEARTYPE_CLEAR) {
                convo.getDialogEntries().clear();
            }

            boolean parsing = false;
            Dialog_Entry workingEntry = null;
            while (in.ready()) {
                String readline = in.readLine();
                //System.err.println(readline);
                if (readline.startsWith("#(")) {
                    if (parsing) {
                        parsing = false;
                        added += addEntry(workingEntry, convo, cleartype);
                    }

                    parsing = true;
                    String[] splitted = readline.split("\\s");
                    if (splitted.length >= 1) {
                        workingEntry = new Dialog_Entry();
                        workingEntry.dialogIdentifier = splitted[0].replace("#(", "").replace(")", "");
                    }
                    if (splitted.length >= 2) {
                        workingEntry.voiceFilename = splitted[1];
                    } else {
                        workingEntry.voiceFilename = "";
                    }
                } else if (readline.equals("") && parsing) {
                    parsing = false;
                    added += addEntry(workingEntry, convo, cleartype);
                    //System.err.println("Parsing complete -- " + workingEntry);
                    //System.err.println(workingEntry.render());
                } else if (parsing == true) {
                    //System.err.println("Adding: [" + readline + "]");
                    workingEntry.dialogString += readline + "\r\n";
                }
            }
            if (parsing) {
                parsing = false;
                added += addEntry(workingEntry, convo, cleartype);
            }
            return added;
        } catch (IOException ex) {
            Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    private static int addEntry(Dialog_Entry entry, Conversation convo, int cleartype) {
        Dialog_Entry removeEntry = null;
        boolean found = false;
        int retval = 0;

        if (cleartype != CLEARTYPE_CLEAR) {
            for (Dialog_Entry e : convo.getDialogEntries()) {
                if (e.dialogIdentifier.equals(entry.dialogIdentifier)) {
                    if (cleartype == CLEARTYPE_OVERWRITE || cleartype == CLEARTYPE_NO_OVERWRITE) {
                        removeEntry = e; //save it for removing later
                        found = true;
                    }
                }
            }
        }

        if (removeEntry != null && cleartype == CLEARTYPE_OVERWRITE) {
            convo.getDialogEntries().remove(removeEntry);
        }
        if (!(found && cleartype == CLEARTYPE_NO_OVERWRITE)) {
            entry.finalize_init();
            convo.getDialogEntries().add(entry);
            retval = 1;
        }
        return retval;
    }
}
