/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.filestuff;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uqmconversation.UQMConversationTool;

public class AbstractFile {

    public enum FileType {

        regularfile,
        inzipfile
    }
    //All:
    public FileType ftype;
    public String fheader = "";
    //regularfile:
    private File file;
    //inzipfile:
    private ZipFile zipfile;
    private ZipEntry zipentry;

    public AbstractFile(File f) throws IOException {
        this.ftype = FileType.regularfile;
        this.file = f;
        //System.err.println(f.getPath());
        this.fheader = "";
        if (!f.getPath().startsWith("content\\comm")) {
            int indexof = f.getPath().indexOf("content");
            if (indexof != -1) {
                this.fheader = f.getPath().substring(indexof+8, f.getPath().length());
                this.fheader = this.fheader.substring(0,this.fheader.indexOf("\\")).toUpperCase();
                //System.err.println(this.fheader);
            }
        }

    }

    public AbstractFile(ZipFile zipfile, ZipEntry zipentry) {
        this.ftype = FileType.inzipfile;
        this.zipfile = zipfile;
        this.zipentry = zipentry;
        this.fheader = zipfile.getName().substring(zipfile.getName().lastIndexOf("\\") + 1, zipfile.getName().length());
    }

    public BufferedReader getBufferedReader() throws IOException {
        if (ftype == FileType.inzipfile) {
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(zipentry));
            InputStreamReader ir = new InputStreamReader(zipfile.getInputStream(zipentry));
            BufferedReader br = new BufferedReader(ir);
            return br;
        } else if (ftype == FileType.regularfile) {
            return new BufferedReader(new FileReader(file));
        } else {
            return null;
        }
    }

    public File getFile() throws IOException {
        if (ftype == FileType.inzipfile) {
            String entryStr = "content/" + (UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH","").equals("") ? "" : UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH","") + "/") + zipentry.getName();
            File f = new File(entryStr.replace("/", "\\"));
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            return f;
        } else if (ftype == FileType.regularfile) {
            return file;
        } else {
            return null;
        }
    }

    public String getFname() {
        if (ftype == FileType.inzipfile) {
            return zipentry.getName(); //Probably returns a wrong name
        } else if (ftype == FileType.regularfile) {
            return file.getName();
        } else {
            return "ERROR";
        }
    }

    @Override
    public String toString() {
        if (ftype == FileType.inzipfile) {
            return (!fheader.equals("") ? "[" + fheader + "]" : "") + zipentry.getName();
        } else if (ftype == FileType.regularfile) {
            return (!fheader.equals("") ? "[" + fheader + "]" : "") + getFname();
        } else {
            return "ERROR";
        }
    }
}
