/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;

@XStreamAlias("convoNode")
public class ConvoNode extends Function {
    ArrayList<ConvoOption> options;

    public ConvoNode(String name) {
        super(name);
        this.options = new ArrayList<ConvoOption>();
    }

    public void addOption(ConvoOption co) {
        options.add(co);
    }

    public ArrayList<ConvoOption> getOptions() {
        return options;
    }

    

    @Override
    public String render_definition() {
        String retstr = "static void\n"
                + getName() + " (RESPONSE_REF R)\n"
                + "{\n"
                + "\t//START BODY GENERATE\n";
        for (Statement s : getStatements()) {
            retstr += "\t" + s.render() + "\n";
        }
        for (ConvoOption o : options) {
            retstr += "\t" + o.getZelnickResponsestatement().render();
        }
        retstr += "\t//END BODY GENERATE\n"
                + "}\n";
        retstr += "//Functions used in " + getName() + "\n";
        for (ConvoOption o : options) {
            retstr += o.getFunction().render_definition();
        }
        return retstr;
    }

    @Override
    public String render_declaration() {
        String retstr =  "static void\n"
                + getName() + " (RESPONSE_REF R);\n";
        for (ConvoOption o : options) {
            retstr += o.getFunction().render_declaration();
        }
        return retstr;
    }



}
