/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;

@XStreamAlias("CODE")
public class Code {

    private ArrayList<Function> functions;
    private Function entryPoint = null;

    public Code() {
        functions = new ArrayList<Function>();
    }

    public boolean addFunction(Function function) {
        boolean ret = true;
        for (Function f : functions) {
            if (f.getName().equals(function.getName())) {
                ret = false;
            }
        }
        if (ret) {
            functions.add(function);
        }
        return ret;
    }

    public boolean addFunction(String name) {
        return addFunction(new Function(name));
    }

    public String render() {
        String retstring = "//AUTOGENERATED BY UQMCONVERSATION TOOL\n\n//FUNCTION DECLARATIONS:\n";
        for (Function f : functions) {
            retstring += f.render_declaration();
        }
        retstring += "\n//FUNCTION DEFINITIONS:\n";
        for (Function f : functions) {
            retstring += f.render_definition();
        }
        return retstring;
    }

    public ArrayList<Function> getFunctions() {
        return functions;
    }

    public void setEntryPoint(Function entryPoint) {
        this.entryPoint = entryPoint;
    }

    public Function getEntryPoint() {
        return entryPoint;
    }

    
   
}
