/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FunctionEditor.java
 *
 * Created on 6-okt-2010, 21:13:25
 */
package uqmconversation.GUIElements;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.Function;
import uqmconversation.domain.Statement;

/**
 *
 * @author joris
 */
public class FunctionEditor extends javax.swing.JDialog {

    private static int BUTTONHEIGHT = 30;
    private Conversation convo;
    private Function function;

    private class myActionListener implements ActionListener {

        private Statement stat;
        private JButton parentbutton;
        private Conversation convo;

        public myActionListener(Statement stat, JButton parentbutton, Conversation convo) {
            this.stat = stat;
            this.parentbutton = parentbutton;
            this.convo = convo;
        }

        public void actionPerformed(ActionEvent e) {
            StatementEditor s = new StatementEditor(null, null, convo);
            s.setVisible(true);
            stat = s.getStatement();
            JOptionPane.showMessageDialog(null, "FORKS: " + s.getStatement().render());
            parentbutton.setText(stat.render());
        }
    }

    /** Creates new form FunctionEditor */
    public FunctionEditor(java.awt.Frame parent, Function func, Conversation convo) {
        super(parent, true);
        this.convo = convo;
        this.function = func;
        initComponents();
        redraw();
        this.tbFunctionName.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                function.setName(tbFunctionName.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                function.setName(tbFunctionName.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                function.setName(tbFunctionName.getText());
            }
        });
    }

    private void redraw() {
        pnlStatements.removeAll();
        tbFunctionName.setText(this.function.getName());
        int locY = 0;
        for (final Statement stat : function.getStatements()) {
            JButton statB = new JButton(stat.render());
            statB.addActionListener(new myActionListener(stat, statB, convo));

            statB.setSize(pnlStatements.getWidth(), BUTTONHEIGHT);
            statB.setLocation(0, locY);
            pnlStatements.add(statB);
            locY += BUTTONHEIGHT;
        }
        pnlStatements.updateUI();
    }

    public Function getFunction() {
        return function;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlStatements = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        tbFunctionName = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Function Editor");

        pnlStatements.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        javax.swing.GroupLayout pnlStatementsLayout = new javax.swing.GroupLayout(pnlStatements);
        pnlStatements.setLayout(pnlStatementsLayout);
        pnlStatementsLayout.setHorizontalGroup(
            pnlStatementsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 563, Short.MAX_VALUE)
        );
        pnlStatementsLayout.setVerticalGroup(
            pnlStatementsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 356, Short.MAX_VALUE)
        );

        jLabel1.setText("Statements:");

        jLabel2.setText("Function name:");

        tbFunctionName.setText("jTextField1");

        jButton1.setText("Add statement");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("Set as entryPoint");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(pnlStatements, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tbFunctionName, javax.swing.GroupLayout.DEFAULT_SIZE, 489, Short.MAX_VALUE))
                    .addComponent(jLabel1)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButton2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(tbFunctionName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnlStatements, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(1, 1, 1)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(jButton2))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        StatementEditor se = new StatementEditor(null, null, convo);
        se.setVisible(true);
        if (se.getStatement() != null) {
            function.addStatement(se.getStatement());
        } else {
            JOptionPane.showMessageDialog(null, "No statement added");
        }
        redraw();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        convo.getCode().setEntryPoint(function);
    }//GEN-LAST:event_jButton2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel pnlStatements;
    private javax.swing.JTextField tbFunctionName;
    // End of variables declaration//GEN-END:variables
}
