/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.GUIElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.ConvoNode;
import uqmconversation.domain.ConvoOption;
import uqmconversation.domain.Function;

public class ConvoNodePanel extends JPanel {

    private static final int CONVOOPTADD = 20;
    private ConvoNode convoNode;
    private Conversation convo;
    private JPanel parentpanel;

    public ConvoNode getConvoNode() {
        return convoNode;
    }

    public ConvoNodePanel(Dimension d, JPanel parent, ConvoNode convoNode, Conversation convo) {
        super();
        this.parentpanel = parent;
        this.setBackground(new Color(255, 200, 200));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));

        if (convoNode == null) {
            boolean proceed = false;
            String func_name = "";
            while (!proceed) {
                proceed = true;
                func_name = JOptionPane.showInputDialog("Conversation node (function) name?");
                for (Function f : convo.getCode().getFunctions()) {
                    if (f.getName().equals(func_name)) {
                        JOptionPane.showMessageDialog(parent, "Conversation node (function) name already in use; please try another one!");
                        proceed = false;
                    }
                }
            }
            this.convoNode = new ConvoNode(func_name);
            convo.getCode().addFunction(this.convoNode);
        } else {
            this.convoNode = convoNode;
        }
        this.convo = convo;



        setSize(d);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        //setLayout(new FlowLayout(FlowLayout.LEFT));
        setLocation(10, 10);
        setVisible(true);

        parent.add(this);
        parent.updateUI();

        addMouseListener(new MyMouseListener());
        recalc();
    }

    public void recalc() {
        removeAll();
        setToolTipText("<html><pre>" + this.convoNode.render_definition().replace("\t","  ") + "</pre></html>");
        
        JLabel l = new JLabel("---" + this.convoNode.getName() + "---");
        l.setFont(l.getFont().deriveFont(Font.BOLD, 20));
        //l.setLocation(10,2);
        this.add(l);
        //this.add(l, new FlowLayout(FlowLayout.CENTER));

        //int iY = 25;
        for (ConvoOption co : convoNode.getOptions()) {
            JLabel l2 = new JLabel("" + co);
            l2.setFont(l2.getFont().deriveFont(Font.PLAIN, 13));
            //l2.setLocation(20, iY);
            this.add(l2);
            //this.add(l2, new FlowLayout(FlowLayout.LEFT));
            //iY += CONVOOPTADD;
        }

        if (convo.getCode().getEntryPoint() == this.convoNode) {
            this.setBorder(BorderFactory.createLineBorder(Color.red, 5));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        }

        this.doLayout();
        updateUI();
        recalcSize();
        updateUI();
    }

    private void recalcSize() {
        double maxx = 0, maxy = 0;
        for (Component c : getComponents()) {
            double temp = 0;
            temp = c.getPreferredSize().getWidth();
            if (temp > maxx) {
                maxx = temp;
            }
            temp = c.getBounds().getMaxY();
            if (temp > maxy) {
                maxy = temp;
            }
        }
        this.setSize((int) maxx + 10, (int) maxy + 10);
    }

    private class MyMouseMotionListener implements MouseMotionListener {

        private int mousestart_x, mousestart_y;
        private int mousestart_loc_x, mousestart_loc_y;

        public MyMouseMotionListener(int mousestart_x, int mousestart_y, int mousestart_loc_x, int mousestart_loc_y) {
            this.mousestart_x = mousestart_x;
            this.mousestart_y = mousestart_y;
            this.mousestart_loc_x = mousestart_loc_x;
            this.mousestart_loc_y = mousestart_loc_y;
        }

        public void mouseDragged(MouseEvent e) {
            setLocation(Math.max(0,(e.getXOnScreen() - mousestart_x) + mousestart_loc_x), Math.max(0,(e.getYOnScreen() - mousestart_y) + mousestart_loc_y));
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class MyMouseListener implements MouseListener {

        private MyMouseMotionListener myml;

        public MyMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == e.BUTTON1) { //left mouse button
                myml = new MyMouseMotionListener(e.getXOnScreen(), e.getYOnScreen(), getLocation().x, getLocation().y);
                addMouseMotionListener(myml);
            } else if (e.getButton() == e.BUTTON3) { //right mouse button
                ConvoNodeEditor fe = new ConvoNodeEditor(null, convoNode, convo);
                fe.setVisible(true);
                convoNode = fe.getConvoNode();
                recalc();
                for (Component c : parentpanel.getComponents()) {
                    if (c.getClass() == ConvoNodePanel.class) {
                        ((ConvoNodePanel)c).recalc();
                    } else if (c.getClass() == FunctionPanel.class) {
                        ((FunctionPanel)c).recalc();
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            removeMouseMotionListener(myml);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}
