/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ConversationSim.java
 *
 * Created on 17-okt-2010, 14:46:33
 */
package uqmconversation.GUIElements;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.plaf.basic.BasicToolBarUI.DockingListener;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.ConvoNode;
import uqmconversation.domain.ConvoOption;
import uqmconversation.domain.Dialog_Entry;
import uqmconversation.domain.Function;
import uqmconversation.domain.Statement;
import uqmconversation.domain.UQMCustomCode;
import uqmconversation.domain.UQMDisableResponse;
import uqmconversation.domain.UQMFunctionCall;
import uqmconversation.domain.UQMNPCPhrase;
import uqmconversation.domain.UQMZelnickResponse;
import uqmconversation.miscclasses.DoubleClickListener;

/**
 *
 * @author joris
 */
public class ConversationSim extends javax.swing.JFrame {

    private Conversation convo;
    private Function currentFunction;
    private DefaultListModel dmL;
    private ArrayList<Dialog_Entry> disabledEntries;

    @Override
    public void pack() {
        super.pack();
    }

    /** Creates new form ConversationSim */
    public ConversationSim(Conversation convo) {
        initComponents();
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        if (convo != null) {
            if (convo.getCode().getEntryPoint() != null) {
                dmL = new DefaultListModel();
                jList1.setModel(dmL);
                disabledEntries = new ArrayList<Dialog_Entry>();
                this.convo = convo;
                this.currentFunction = convo.getCode().getEntryPoint();
                jList1.addMouseListener(new DoubleClickListener() {

                    @Override
                    public void doubleClicked(MouseEvent e) {
                        currentFunction = ((ConvoOption) jList1.getSelectedValue()).getFunction();
                        refreshStuff(false);
                    }
                });
                refreshStuff(false);
                this.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(rootPane, "<html>We have a null entry point for this conversation.<br>Please select one function or convoNode to serve as the entry point.</html>");
                this.dispose();
                this.setVisible(false); //TODO: messy hack fix?
            }
        } else {
            JOptionPane.showMessageDialog(rootPane, "Null convo!");
            this.dispose();
            this.setVisible(false); //TODO: messy hack fix?
        }
    }

    private boolean parseFoop(Function func) {
        for (Statement s : func.getStatements()) {
            if (s.getClass() == UQMNPCPhrase.class) {
                if (!disabledEntries.contains(((UQMNPCPhrase) s).getDialogEntry())) {
                    jTextArea1.append("\n" + ((UQMNPCPhrase) s).getDialogEntry().dialogString);
                }
            } else if (s.getClass() == UQMZelnickResponse.class) {
                if (!disabledEntries.contains(((UQMZelnickResponse) s).getDialogEntry())) {
                    dmL.addElement(s);
                }
            } else if (s.getClass() == UQMFunctionCall.class) {
                currentFunction = ((UQMFunctionCall) s).getFunction();
                return true;
            } else if (s.getClass() == UQMDisableResponse.class) {
                disabledEntries.add(((UQMDisableResponse) s).getDialogEntry());
            } else if (s.getClass() == UQMCustomCode.class) {
                jTextArea2.append("\nCustomCode element found, unable to parse: " + ((UQMCustomCode)s).getBody());
            } else {
                jTextArea2.append("\nUnknown statement found of class: " + s.getClass());
            }
        }
        return false;
    }

    private void refreshStuff(boolean recalled) {
        if (!recalled) {
            dmL.clear();
            jTextArea1.setText("");
        }
        boolean recall = parseFoop(currentFunction);
        if (!recall) {
            if (currentFunction.getClass() == ConvoNode.class) {
                for (ConvoOption o : ((ConvoNode) currentFunction).getOptions()) {
                    if (!disabledEntries.contains(o.getZelnickResponsestatement().getDialogEntry())) {
                        dmL.addElement(o);
                    }
                }
            }
        }

        jList1.updateUI();
        if (recall) {
            refreshStuff(true);
        }
        jTextArea1.setText(jTextArea1.getText().trim());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextArea2 = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Conversation Simulator");
        setBackground(new java.awt.Color(51, 51, 51));

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jTextArea1.setBackground(new java.awt.Color(51, 51, 0));
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setForeground(new java.awt.Color(204, 255, 51));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(5);
        jTextArea1.setText("bla die bla die bla");
        jTextArea1.setWrapStyleWord(true);
        jScrollPane1.setViewportView(jTextArea1);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 642, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 225, Short.MAX_VALUE)
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jList1.setBackground(new java.awt.Color(0, 102, 153));
        jList1.setForeground(new java.awt.Color(153, 255, 255));
        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane2.setViewportView(jList1);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 642, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 165, Short.MAX_VALUE)
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jTextArea2.setColumns(20);
        jTextArea2.setEditable(false);
        jTextArea2.setRows(5);
        jTextArea2.setText("Warnings:");
        jScrollPane3.setViewportView(jTextArea2);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 642, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 107, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextArea jTextArea2;
    // End of variables declaration//GEN-END:variables
}
