/*
 * Decompiled with CFR 0.152.
 */
package uqmconversation.filestuff;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import uqmconversation.UQMConversationTool;
import uqmconversation.filestuff.AbstractFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileList {
    public String COMMDIR = "content\\comm";
    public String PACKDIR = "content\\packages";
    private ArrayList<AbstractFile> filelist = new ArrayList();

    public FileList() throws ZipException, IOException {
        this.refresh();
    }

    public void refresh() throws ZipException, IOException {
        this.filelist.clear();
        this.refresh_parseDir("content\\comm", "");
        if (!UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH", "").equals("")) {
            this.refresh_parseDir("content\\" + UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH", "") + "\\comm", UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH", "").toUpperCase());
        }
        this.refresh_parseUQM(this.PACKDIR);
    }

    public void setFilelist(ArrayList<AbstractFile> filelist) {
        this.filelist = filelist;
    }

    public void setCOMMDIR(String COMMDIR) {
        this.COMMDIR = COMMDIR;
    }

    public void setPACKDIR(String PACKDIR) {
        this.PACKDIR = PACKDIR;
    }

    public void refresh_parseUQM(String packagesDirStr) throws ZipException, IOException {
        File packagesdir = new File(packagesDirStr);
        if (packagesdir.exists()) {
            File[] uqmfiles;
            for (File uqmfile : uqmfiles = packagesdir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".uqm");
                }
            })) {
                ZipFile zipfile = new ZipFile(uqmfile);
                Enumeration<? extends ZipEntry> e = zipfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().matches(".*/?comm/\\S*/\\S*\\.txt") && !entry.getName().matches(UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH", "") + "/comm/\\S*/\\S*\\.txt")) continue;
                    AbstractFile abs = new AbstractFile(zipfile, entry);
                    this.filelist.add(abs);
                }
            }
        }
    }

    public void refresh_parseDir(String dirStr, String header) throws IOException {
        File dir = new File(dirStr);
        File[] files = dir.listFiles();
        ArrayList<File> dialogfiles = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                File[] textfiles = file.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".txt");
                    }
                });
                dialogfiles.addAll(Arrays.asList(textfiles));
            }
        }
        for (File dialogfile : dialogfiles) {
            AbstractFile abs = new AbstractFile(dialogfile);
            abs.fheader = header;
            this.filelist.add(abs);
        }
    }

    public ArrayList<AbstractFile> getFilelist() {
        return this.filelist;
    }
}

