/*
 * Decompiled with CFR 0.152.
 */
package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import uqmconversation.domain.Statement;
import uqmconversation.domain.UQMZelnickResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="function")
public class Function {
    private String name;
    private ArrayList<Statement> statements;

    public Function(String name) {
        this.name = name;
        this.statements = new ArrayList();
    }

    public String render_definition() {
        String retstr = "static void\n" + this.name + " (RESPONSE_REF R)\n" + "{\n" + "\t//START BODY GENERATE\n";
        for (Statement s : this.statements) {
            retstr = retstr + "\t" + s.render() + "\n";
        }
        retstr = retstr + "\t//END BODY GENERATE\n}\n";
        return retstr;
    }

    public String render_declaration() {
        return "static void\n" + this.name + " (RESPONSE_REF R);\n";
    }

    public String getName() {
        return this.name;
    }

    public void addStatement(Statement statement) {
        UQMZelnickResponse resp;
        this.statements.add(statement);
        if (statement instanceof UQMZelnickResponse && (resp = (UQMZelnickResponse)statement).getFunction() == this) {
            System.err.println("Warning: possible recursion in " + this.toString() + "!");
        }
    }

    public String toString() {
        return "function " + this.name;
    }

    public ArrayList<Statement> getStatements() {
        return this.statements;
    }

    public void setName(String name) {
        this.name = name;
    }
}

