/*
 * Decompiled with CFR 0.152.
 */
package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.UUID;
import uqmconversation.domain.Dialog_Entry;
import uqmconversation.domain.Function;
import uqmconversation.domain.Statement;
import uqmconversation.domain.UQMDisableResponse;
import uqmconversation.domain.UQMFunctionCall;
import uqmconversation.domain.UQMNPCPhrase;
import uqmconversation.domain.UQMZelnickResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="convoOption")
public class ConvoOption {
    private Function function;
    private UQMZelnickResponse zelnickResponse;

    public ConvoOption(Dialog_Entry zelnickOption, ArrayList<Dialog_Entry> alienPhrases, Function nextFunction, Boolean disablePhrase) {
        this.refresh(zelnickOption, alienPhrases, nextFunction, disablePhrase);
    }

    public void refresh(Dialog_Entry zelnickOption, ArrayList<Dialog_Entry> alienPhrases, Function nextFunction, Boolean disablePhrase) {
        this.function = new Function(("genF_" + UUID.randomUUID()).replace("-", "_"));
        if (disablePhrase.booleanValue()) {
            this.function.addStatement(new UQMDisableResponse(zelnickOption));
        }
        for (Dialog_Entry alienPhrase : alienPhrases) {
            this.function.addStatement(new UQMNPCPhrase(alienPhrase));
        }
        this.function.addStatement(new UQMFunctionCall(nextFunction, "R"));
        this.zelnickResponse = new UQMZelnickResponse(zelnickOption, this.function);
    }

    public UQMZelnickResponse getZelnickResponsestatement() {
        return this.zelnickResponse;
    }

    public Function getFunction() {
        return this.function;
    }

    public ArrayList<UQMNPCPhrase> getAlienPhrases() {
        ArrayList<UQMNPCPhrase> retlist = new ArrayList<UQMNPCPhrase>();
        for (Statement s : this.function.getStatements()) {
            if (s.getClass() != UQMNPCPhrase.class) continue;
            retlist.add((UQMNPCPhrase)s);
        }
        if (retlist.isEmpty()) {
            System.err.println("Error: getAlienPhrases returned no alien phrase in {" + this.function.getName() + "}!");
        }
        return retlist;
    }

    public Function getNextFunction() {
        for (Statement s : this.function.getStatements()) {
            if (s.getClass() != UQMFunctionCall.class) continue;
            return ((UQMFunctionCall)s).getFunction();
        }
        System.err.println("Error: getNextFunction returned no function in {" + this.function.getName() + "}!");
        return null;
    }

    public boolean getDisablePhrase() {
        for (Statement s : this.function.getStatements()) {
            if (s.getClass() != UQMDisableResponse.class || ((UQMDisableResponse)s).getDialogEntry() != this.zelnickResponse.getDialogEntry()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getZelnickResponsestatement().getDialogEntry().dialogString;
    }
}

