/*
 * Decompiled with CFR 0.152.
 */
package uqmconversation.GUIElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uqmconversation.GUIElements.ConvoNodePanel;
import uqmconversation.GUIElements.FunctionEditor;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.Function;
import uqmconversation.domain.Statement;

public class FunctionPanel
extends JPanel {
    private Function function;
    private Conversation convo;
    private JPanel parentpanel;

    public FunctionPanel(Dimension d, JPanel parent, Function function, Conversation convo) {
        this.setBackground(Color.CYAN);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
        this.parentpanel = parent;
        if (function == null) {
            boolean proceed = false;
            String func_name = "";
            while (!proceed) {
                proceed = true;
                func_name = JOptionPane.showInputDialog("Function name?");
                for (Function f : convo.getCode().getFunctions()) {
                    if (!f.getName().equals(func_name)) continue;
                    JOptionPane.showMessageDialog(parent, "Function name already in use; please try another one!");
                    proceed = false;
                }
            }
            this.function = new Function(func_name);
            convo.getCode().addFunction(this.function);
        } else {
            this.function = function;
        }
        this.convo = convo;
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(d);
        this.setSize(d);
        this.setLocation(10, 10);
        this.setVisible(true);
        parent.add(this);
        parent.updateUI();
        this.addMouseListener(new MyMouseListener());
        this.recalc();
    }

    public void recalc() {
        this.removeAll();
        this.setToolTipText("<html><pre>" + this.function.render_definition().replace("\t", "  ") + "</pre></html>");
        JLabel l = new JLabel("---" + this.function.getName() + "---");
        l.setFont(l.getFont().deriveFont(1, 20.0f));
        this.add(l);
        for (Statement s : this.function.getStatements()) {
            JLabel l2 = new JLabel("" + s);
            l2.setFont(l2.getFont().deriveFont(0, 13.0f));
            this.add(l2);
        }
        if (this.convo.getCode().getEntryPoint() == this.function) {
            this.setBorder(BorderFactory.createLineBorder(Color.red, 5));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        }
        this.doLayout();
        this.updateUI();
        this.recalcSize();
        this.updateUI();
    }

    private void recalcSize() {
        double maxx = 0.0;
        double maxy = 0.0;
        for (Component c : this.getComponents()) {
            double temp = 0.0;
            temp = c.getPreferredSize().getWidth();
            if (temp > maxx) {
                maxx = temp;
            }
            if (!((temp = c.getBounds().getMaxY()) > maxy)) continue;
            maxy = temp;
        }
        this.setSize((int)maxx + 10, (int)maxy + 10);
    }

    private class MyMouseListener
    implements MouseListener {
        private MyMouseMotionListener myml;

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.myml = new MyMouseMotionListener(e.getXOnScreen(), e.getYOnScreen(), FunctionPanel.this.getLocation().x, FunctionPanel.this.getLocation().y);
                FunctionPanel.this.addMouseMotionListener(this.myml);
            } else if (e.getButton() == 3) {
                FunctionEditor fe = new FunctionEditor(null, FunctionPanel.this.function, FunctionPanel.this.convo);
                fe.setVisible(true);
                FunctionPanel.this.recalc();
                for (Component c : FunctionPanel.this.parentpanel.getComponents()) {
                    if (c.getClass() == ConvoNodePanel.class) {
                        ((ConvoNodePanel)c).recalc();
                        continue;
                    }
                    if (c.getClass() != FunctionPanel.class) continue;
                    ((FunctionPanel)c).recalc();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            FunctionPanel.this.removeMouseMotionListener(this.myml);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private int mousestart_x;
        private int mousestart_y;
        private int mousestart_loc_x;
        private int mousestart_loc_y;

        public MyMouseMotionListener(int mousestart_x, int mousestart_y, int mousestart_loc_x, int mousestart_loc_y) {
            this.mousestart_x = mousestart_x;
            this.mousestart_y = mousestart_y;
            this.mousestart_loc_x = mousestart_loc_x;
            this.mousestart_loc_y = mousestart_loc_y;
        }

        public void mouseDragged(MouseEvent e) {
            FunctionPanel.this.setLocation(Math.max(0, e.getXOnScreen() - this.mousestart_x + this.mousestart_loc_x), Math.max(0, e.getYOnScreen() - this.mousestart_y + this.mousestart_loc_y));
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

