/*
 * Decompiled with CFR 0.152.
 */
package uqmconversation.GUIElements;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uqmconversation.GUIElements.StatementEditor;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.Function;
import uqmconversation.domain.Statement;

public class FunctionEditor
extends JDialog {
    private static int BUTTONHEIGHT = 30;
    private Conversation convo;
    private Function function;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel pnlStatements;
    private JTextField tbFunctionName;

    public FunctionEditor(Frame parent, Function func, Conversation convo) {
        super(parent, true);
        this.convo = convo;
        this.function = func;
        this.initComponents();
        this.redraw();
        this.tbFunctionName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FunctionEditor.this.function.setName(FunctionEditor.this.tbFunctionName.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                FunctionEditor.this.function.setName(FunctionEditor.this.tbFunctionName.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                FunctionEditor.this.function.setName(FunctionEditor.this.tbFunctionName.getText());
            }
        });
    }

    private void redraw() {
        this.pnlStatements.removeAll();
        this.tbFunctionName.setText(this.function.getName());
        int locY = 0;
        for (Statement stat : this.function.getStatements()) {
            JButton statB = new JButton(stat.render());
            statB.addActionListener(new myActionListener(stat, statB, this.convo));
            statB.setSize(this.pnlStatements.getWidth(), BUTTONHEIGHT);
            statB.setLocation(0, locY);
            this.pnlStatements.add(statB);
            locY += BUTTONHEIGHT;
        }
        this.pnlStatements.updateUI();
    }

    public Function getFunction() {
        return this.function;
    }

    private void initComponents() {
        this.pnlStatements = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tbFunctionName = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Function Editor");
        this.pnlStatements.setBorder(BorderFactory.createBevelBorder(1));
        GroupLayout pnlStatementsLayout = new GroupLayout(this.pnlStatements);
        this.pnlStatements.setLayout(pnlStatementsLayout);
        pnlStatementsLayout.setHorizontalGroup(pnlStatementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 563, Short.MAX_VALUE));
        pnlStatementsLayout.setVerticalGroup(pnlStatementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 356, Short.MAX_VALUE));
        this.jLabel1.setText("Statements:");
        this.jLabel2.setText("Function name:");
        this.tbFunctionName.setText("jTextField1");
        this.jButton1.setText("Add statement");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Set as entryPoint");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionEditor.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlStatements, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbFunctionName, -1, 489, Short.MAX_VALUE)).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tbFunctionName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlStatements, -2, -1, -2).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        StatementEditor se = new StatementEditor(null, null, this.convo);
        se.setVisible(true);
        if (se.getStatement() != null) {
            this.function.addStatement(se.getStatement());
        } else {
            JOptionPane.showMessageDialog(null, "No statement added");
        }
        this.redraw();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.convo.getCode().setEntryPoint(this.function);
    }

    private class myActionListener
    implements ActionListener {
        private Statement stat;
        private JButton parentbutton;
        private Conversation convo;

        public myActionListener(Statement stat, JButton parentbutton, Conversation convo) {
            this.stat = stat;
            this.parentbutton = parentbutton;
            this.convo = convo;
        }

        public void actionPerformed(ActionEvent e) {
            StatementEditor s = new StatementEditor(null, null, this.convo);
            s.setVisible(true);
            this.stat = s.getStatement();
            JOptionPane.showMessageDialog(null, "FORKS: " + s.getStatement().render());
            this.parentbutton.setText(this.stat.render());
        }
    }
}

