/*

	This is compiled to create both 'Normal Go!' and 'Alternate Go!'.
	Normal Go runs Noctis.exe, Alternate Go runs NoctisNN.exe.
	
	Both attempt to copy modules\base.pif to create a new PIF file with the optimal settings
	and the correct folder path prior to running Noctis. If the PIF is not long
	enough to hold the autoexec.nt and config.nt paths, those are not read and
	are not written. Thus it should work even if base.pif is an old PIF format
	which lacks those fields.

	Additionally, this should still work even if base.pif is completely absent.
	
	-Shadowlord
*/

#include <stdlib.h>
#include <windows.h>
#include <stdio.h>

char *currentDirectory = NULL;
unsigned long curDirLen = 0;
unsigned char *data = NULL;
unsigned long fileLen = 0;

int Win_95_98_ME = 0;

char name[31];				//2
char pathAndFilename[64];	//36
char configNTPath[65];		//579
char autoexecNTPath[65];	//643

void ReadPif(char *path) {
	if (data!=NULL) {
		delete [] data;
		data = NULL;
	}
	FILE * pif = fopen(path, "rb");
	if (pif==NULL) {
		fileLen = 0;
		return;
	}
	fseek(pif, 0, SEEK_END);
	fileLen = ftell(pif);
	fseek(pif, 0, SEEK_SET);
	data = new unsigned char[fileLen];
	
	fseek(pif, 2, SEEK_SET);
	fread(&name, 30, 1, pif);
	name[30]=0;
	fseek(pif, 36, SEEK_SET);
	fread(&pathAndFilename, 63, 1, pif);
	pathAndFilename[63]=0;
	if (!Win_95_98_ME) {
		if (fileLen>643+64) {
			fseek(pif, 579, SEEK_SET);
			fread(&configNTPath, 64, 1, pif);
			configNTPath[64]=0;
			fseek(pif, 643, SEEK_SET);
			fread(&autoexecNTPath, 64, 1, pif);
			autoexecNTPath[64]=0;
		}
	}
	fseek(pif, 0, SEEK_SET);
	
	fread(data, fileLen, 1, pif);
	fclose(pif);
	/*
	FILE *info = fopen("info.txt", "wt");
	fprintf(info, "name=%s\n", name);
	fprintf(info, "pathAndFilename=%s\n", pathAndFilename);
	if (fileLen>643+64) {
		fprintf(info, "configNTPath=%s\n", configNTPath);
		fprintf(info, "autoexecNTPath=%s\n", autoexecNTPath);
	}
	fclose(info);*/
}

#ifdef MULTI
void WritePif(char *pifPath, char *currentDirectory, int moduleNum) {
#else
void WritePif(char *pifPath, char *currentDirectory) {
#endif	
	if (fileLen==0) return;
	//TODO: GetVersionEx, delete pif for old windowses	//http://msdn.microsoft.com/library/default.asp?url=/library/en-us/sysinfo/base/getversionex.asp
	FILE * pif = fopen(pifPath, "wb");
	fwrite(data, fileLen, 1, pif);
	fseek(pif, 36, SEEK_SET);
#ifdef MULTI
	sprintf(pathAndFilename, "noctis%02i.exe\0", moduleNum);
#else
	sprintf(pathAndFilename, "noctis.exe\0");
#endif
	fwrite(&pathAndFilename, 63, 1, pif);
	if (!Win_95_98_ME) {
		if (fileLen>643+64) {
			fseek(pif, 579, SEEK_SET);
			int cdlen = strlen(currentDirectory);
			if (currentDirectory[cdlen-1]=='\\') {
				cdlen--;
				currentDirectory[cdlen]=0;
			}
			sprintf(configNTPath, "%s\\modules\\config.nt\0", currentDirectory);
			fwrite(&configNTPath, 64, 1, pif);
			fseek(pif, 643, SEEK_SET);
			sprintf(autoexecNTPath, "%s\\modules\\autoexec.nt\0", currentDirectory);
			fwrite(&autoexecNTPath, 64, 1, pif);
		}
	}
	fclose(pif);
}

void main() {
	char cmdline[120];
	startover:
	/*
	int result = (int) ShellExecute(NULL, NULL, "modules\\noctis.exe", "", NULL, 5);
	if (result<=32) {
		MessageBox(NULL, "Unable to launch MODULES\\NOCTIS.EXE", "WIN32 Noctis Launcher", NULL);
	}*/
	#ifdef MULTI
	char option_temperature, option_flying_lander, option_multiplayer;
	FILE * current = fopen("DATA\\CURRENT.BIN", "rb");
	option_temperature=0;
	option_flying_lander=1;
	option_multiplayer=0;
	if (current!=NULL) {
		if (fseek(current, 370+1, SEEK_SET)==0) {
			option_temperature = fgetc(current);
			if (fseek(current, 370+27, SEEK_SET)==0) {
				option_flying_lander = fgetc(current);
				if (fseek(current, 370+33, SEEK_SET)==0) {
					option_multiplayer = fgetc(current);
					if (fseek(current, 370+33, SEEK_SET)==0) {
						option_multiplayer = fgetc(current);
					}
				}
			}
		}
		fclose(current);
	}
	
	//flying_lander 01
	//multiplayer 02
	//temperature 04
	int moduleNum = option_flying_lander + (option_multiplayer<<1) + (option_temperature<<2);
	#endif
	
	OSVERSIONINFO osversion;
	osversion.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
	if (GetVersionEx(&osversion)) {
		if (osversion.dwMajorVersion==4) {
			Win_95_98_ME=1;
		} else {
			Win_95_98_ME=0;
		}
	} else {
		MessageBox(NULL, "Unable to determine what version of Windows this is!", "Go!", MB_ICONSTOP|MB_OK);
		Win_95_98_ME=0;	//assume it isn't 95/98/ME.
	}
	
	if (Win_95_98_ME) {
		ReadPif("modules\\base9598me.pif");
	} else {
		ReadPif("modules\\base2kxp.pif");
	}
	curDirLen = GetCurrentDirectory(0, NULL);
	if (currentDirectory!=NULL) {
		delete [] currentDirectory;
		currentDirectory=NULL;
	}
	currentDirectory = new char[curDirLen];
	GetCurrentDirectory(curDirLen, currentDirectory);
	if (curDirLen+strlen("modules\\autoexec.nt")>63) {
		MessageBox(NULL, "Sorry, the path is too long, so we can't set up the optimized PIF files!", "WIN32 Noctis Launcher", NULL);
	} else {
		#ifdef MULTI
		sprintf(cmdline, "modules\\noctis%02i.pif", moduleNum);
		WritePif(cmdline, currentDirectory, moduleNum);
		#else
		sprintf(cmdline, "modules\\noctis.pif");
		WritePif(cmdline, currentDirectory);
		#endif
		
	}
	#ifdef MULTI
	sprintf(cmdline, "modules\\noctis%02i.exe", moduleNum);
	#else
	sprintf(cmdline, "modules\\noctis.exe");
	#endif
	
	
	STARTUPINFO si;
	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	PROCESS_INFORMATION pi;
	int flags=IDLE_PRIORITY_CLASS;
	
	if(!CreateProcess("modules\\noctis.exe", NULL, NULL, NULL, FALSE, flags, NULL, NULL,
		&si, &pi))
	{
		printf("Failed to start NIV.\n");
		return;
	}
	
	//system(cmdline);
	FILE *frestart = fopen("DATA\\RESTART.TXT", "rt");
	if (frestart!=NULL) {
		char c = fgetc(frestart);
		if (c=='Y') {
			fclose(frestart);
			goto startover;
		} else {
			fclose(frestart);
			remove("DATA\\RESTART.TXT");
		}
	}
	//cleanup
	if (data!=NULL) {
		delete [] data;
		data = NULL;
	}
	if (currentDirectory!=NULL) {
		delete [] currentDirectory;
		currentDirectory=NULL;
	}
	
}