#ifndef GENALGH
#define GENALGH
#include "defs.h"
#include "randalg.h"

const double deg = M_PI / 180;

#define qt_M_PI   4*M_PI/3

#define star_classes    12
#define planet_types    10
#define avgmoons        4
#define log2avgmoons	2
#define maxbodies	20 * avgmoons

#define advance 100000
#define halfadvance 50000

extern FastBool DoesStarExist (double sect_x, double sect_y, double sect_z);
extern void PrepareFromSectorCoords (Dword sect_x, Dword sect_y, Dword sect_z);
extern void PrepareFromSectorCoords (double sect_x, double sect_y, double sect_z);

extern double foundstar_x, foundstar_y, foundstar_z, foundstar_id;
extern Dword foundstar_sx, foundstar_sy, foundstar_sz;
extern Word    foundstar_class;		// 35
extern Word    foundstar_nop;		// 37
extern float  foundstar_ray;	// 67
extern char   foundstar_spin;          // 18
extern Word	      foundstar_nob;

extern Word class_ray[star_classes];

extern Word class_rayvar[star_classes];

extern Word class_act[star_classes];

extern char class_planets[star_classes];

extern char   foundstar_p_type       [maxbodies];
extern Word    foundstar_p_owner	     [maxbodies];
extern char   foundstar_p_moonid     [maxbodies];
extern double foundstar_p_ring       [maxbodies];
extern double foundstar_p_tilt       [maxbodies];
extern double foundstar_p_ray        [maxbodies];
extern double foundstar_p_orb_ray    [maxbodies];
extern double foundstar_p_orb_seed   [maxbodies];
extern double foundstar_p_orb_tilt   [maxbodies];
extern double foundstar_p_orb_orient [maxbodies];
extern double foundstar_p_orb_ecc    [maxbodies];

extern Word    foundstar_p_rtperiod   [maxbodies];
extern Word    foundstar_p_rotation   [maxbodies];
extern Word    foundstar_p_term_start [maxbodies];
extern Word    foundstar_p_term_end   [maxbodies];

extern Word planet_possiblemoons[];

const double planet_orb_scaling=  5.0;
const double avg_planet_sizing =  2.4;
const double moon_orb_scaling  = 12.8;
const double avg_moon_sizing   =  1.8;

extern double avg_planet_ray[];

extern float mindiff;

extern long ImulAndAdd(long main, long secondary);

extern float zrandom (Word range);

// ---------------------------------------------------------------------------------

extern void extract_foundstar_infos ();
extern void prepare_foundstar ();

// ---------------------------------------------------------------------------------

extern Dword flat_rnd_seed;

extern void fast_srand (Dword seed);

extern Dword fast_random (Dword mask);

extern Word ranged_fast_random (Word range);

extern float flandom ();

extern float fast_flandom ();

#endif