#include <initguid.h>
#include "ddraw.h"

/*
typedef struct _DDSURFACEDESC2
{
    DWORD		dwSize;			// size of the DDSURFACEDESC structure
    DWORD		dwFlags;		// determines what fields are valid
    DWORD		dwHeight;		// height of surface to be created
    DWORD		dwWidth;		// width of input surface
    union {
    	LONG		lPitch;			// distance to start of next line (return value only)
    	DWORD		dwLinearSize;
    };
    DWORD		dwBackBufferCount;	// number of back buffers requested
    union
    {
        DWORD       dwMipMapCount;          // number of mip-map levels requested
		DWORD		dwZBufferBitDepth;	// depth of Z buffer requested
		DWORD		dwRefreshRate;		// refresh rate (used when display mode is described)
    };
    DWORD		dwAlphaBitDepth;	// depth of alpha buffer requested
    DWORD		dwReserved;		// reserved
    LPVOID		lpSurface;		// pointer to the associated surface memory
    DDCOLORKEY		ddckCKDestOverlay;	// color key for destination overlay use
    DDCOLORKEY		ddckCKDestBlt;		// color key for destination blt use
    DDCOLORKEY		ddckCKSrcOverlay;	// color key for source overlay use
    DDCOLORKEY		ddckCKSrcBlt;		// color key for source blt use
    DDPIXELFORMAT	ddpfPixelFormat;	// pixel format description of the surface
    DDSCAPS		ddsCaps;		// direct draw surface capabilities
    DWORD dwTextureStage;
} DDSURFACEDESC2;
*/
LPDIRECTDRAW lpDirectDraw;
LPDIRECTDRAW lpDirectDraw2;
DDCAPS ddCaps;

DDSURFACEDESC ddSurfaceDesc;
LPDIRECTDRAWSURFACE lpDirectDrawSurface;
LPDIRECTDRAWPALETTE lpDirectDrawPalette;
PALETTEENTRY palette[256];


void WinStorePalette(int firstColor, int numColors, Uchar *tmppal) {
	int b=firstColor*3;
	for (int a=firstColor; a<numColors+firstColor; a++, b+=3) {
		palette[a].peRed=tmppal[b]<<2;
		palette[a].peGreen=tmppal[b+1]<<2;
		palette[a].peBlue=tmppal[b+2]<<2;
		palette[a].peFlags=0;
	}
	//lpDirectDrawSurface.SetPalette();
}

void WinBlit() {
	if (hasFocus) {
		//from video buffer
		ddSurfaceDesc.dwFlags=DDSD_PITCH;
		lpDirectDrawSurface->Lock(NULL, &ddSurfaceDesc, DDLOCK_WAIT, NULL);
		Udword pitch = ddSurfaceDesc.lPitch;
		LPVOID lpSurface = ddSurfaceDesc.lpSurface;
		unsigned char * DPtr = Screen;
		unsigned char * DNPtr = Screen+WIDTH;
		unsigned char * VPtr = (unsigned char*) lpSurface;
		unsigned char * VNPtr = VPtr+pitch;
		for (int y=0; y<HEIGHT; y++) {
			
			for (int x=0; x<WIDTH; x++) {
				*VPtr	=	*DPtr;
				VPtr++; 	DPtr++;
			}
			VPtr=VNPtr;		DPtr=DNPtr;
			DNPtr+=WIDTH;	VNPtr+=pitch;
		}
		lpDirectDrawSurface->Unlock(NULL);
		lpDirectDrawSurface->Restore();
	}
}
void WinInitB() {
	HRESULT hr=DirectDrawCreate(NULL, &lpDirectDraw, NULL);
	if (hr==DD_OK) {
		HRESULT ddsuccess=lpDirectDraw->QueryInterface(IID_IDirectDraw2, (void**) &lpDirectDraw2);
		if (ddsuccess==S_OK) {
			lpDirectDraw2->GetCaps(&ddCaps, NULL);
			hWnd=CreateWindowEx(WS_EX_TOOLWINDOW|WS_EX_TOPMOST, "NIV/Win", "NIV/Win", WS_POPUP, 0, 0, WIDTH, HEIGHT,
							NULL, NULL, hInstance, NULL);
			ShowCursor(False);
			
			lpDirectDraw2->SetCooperativeLevel(hWnd,DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
			lpDirectDraw2->SetDisplayMode(WIDTH, HEIGHT, BPP);
			memset(&ddSurfaceDesc, 0, sizeof(DDSURFACEDESC2));
			ddSurfaceDesc.dwSize=sizeof(DDSURFACEDESC2);
			ddSurfaceDesc.dwFlags=DDSD_CAPS;
			ddSurfaceDesc.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
			ddSurfaceDesc.dwHeight=HEIGHT;
			ddSurfaceDesc.dwWidth=WIDTH;
			
			HRESULT ret=lpDirectDraw2->CreateSurface(&ddSurfaceDesc, &lpDirectDrawSurface, NULL);
			
			if (ret==DD_OK) {
				lpDirectDraw2->CreatePalette(DDPCAPS_ALLOW256|DDPCAPS_PRIMARYSURFACE|DDPCAPS_VSYNC, palette, &lpDirectDrawPalette, NULL);
				SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
		    	SetFocus(hWnd);
		    	Screen = (unsigned char*) malloc(WIDTH*HEIGHT);
			} else {
				MessageBox(NULL, "Unable to create surface to draw on.", "Error", MB_OK|MB_ICONERROR);
				exit(0);
			}
		    
		    
		} else {
			MessageBox(NULL, "Is DirectDraw installed?", "Error", MB_OK|MB_ICONERROR);
			exit(0);
		}
	} else {
		MessageBox(NULL, "Can't find DirectDraw?", "Error", MB_OK|MB_ICONERROR);
		exit(0);
	}
	cursorX=WIDTH/2; cursorY=HEIGHT/2;
}