#ifndef NOCTIS2H
#define NOCTIS2H
#ifdef NOCTIS2CPP
#define EXT
#else
#define EXT extern
#endif

#ifdef WINDOWS
EXT clock_t last_ticks;
EXT double clk_convert;
inline clock_t CLOCK() {
	clock_t ticks = clock();
	return (ticks-last_ticks<clk_convert)?last_ticks:(ticks/clk_convert);
}
#endif


//EXT char blinkhudlights;
//EXT char blinkhudlights_stay;

EXT void enableR9aBugMessage();
EXT void disableR9aBugMessage();
EXT void r9aBugMessage();
EXT void FindCritter0();

#define OCEAN	1
#define PLAINS	2
#define DESERT	3
#define ICY	4
#define GLASSIFIED 5
#define LAVA 6
#define ALLLAVA 7
#define MOUNTAIN 8
#define MOUNTAINTOP 9
#define SHRUBLAND 10
#define RAINFOREST 11
#define JUNGLE 12
#define FOREST 13
#define FORESTBORDER 14

//We define these so we can set sctype = planet_type+16. Some aren't used, as those planets aren't landable.
#define UNSTABLE 16
#define DUSTY 17
#define THICKATMO 18
//Also 'FELISIAN' wouldn't really be used, since the regular terrain types would be used instead.
#define FELISIAN 19
#define ROCKY 20
#define THINATMO 21
#define NOTCONSISTANT 22
#define ICYNOATMO 23
#define QUARTZ 24
#define SUBSTELLAR 25
#define COMPANIONSTAR 26

//MTYPE
	//Mammals
	#define FELINE_LIKE	0
	#define RABBIT_LIKE	1
	#define KANGAROO_LIKE	2
	#define APE_LIKE 3
	#define BULL_LIKE 4

	//Reptiles
	//None yet

//TYPE
#define BIRD	1               // definizione tipologia (per classi).
#define REPTIL	4
#define MAMMAL  5

	//Subtypes of specific mammal types
	#define BULL_JUMPER 0
	#define BULL_SPINNER 1
	#define BULL_RUNNER 2
	#define BULL_SOMERSAULTER 3

#ifndef NOCTIS2CPP
EXT Word lastXFps;		//holds the fraction-of-a-second of the last x command.
EXT double lastXSecs;	//holds the seconds of the last x command.
EXT double timeAdjustment;	//Also used by the irc-server-time code (SL):
EXT char dontDraw;
EXT char terrainTypeBuffer[13];
EXT Word secspassed, prevsecs;
EXT double speedCentiDyamsPerS, speedMetersPerS, speedPC, speedWarp;
EXT Dword treeDensity;
EXT Word maxDepth;
EXT Uchar pBullType;
EXT double pBullAngle;

#endif

EXT float moviefps;

EXT void Moose(char *filetoread, int page=1);
EXT void ShowMoose(int page, char standardtext, char html, char background);
EXT void showmap(int showmaptype);
EXT void showpalette();
//EXT void showsurftexture();
EXT void show_newmessage(int helpmessageID);
EXT void ShowAboutPage(FastBool surface);
EXT void ShowBinStat();
EXT void RecalcPlanetStuff(Word onplanet);
EXT void Earthquake(Word *earthtime);
EXT void ShowAdvStat(float crcy, char sctype, float formalappr, float formalbob);
EXT void CalculatemovieFPS(int moviefscap, int moviestime);
EXT void ShowMovieSetup(int moviefsec, char movieflash, int moviedeck);
EXT void BracketAnims();
EXT void live_animal (Word n);

/*
XMS stuff for testing. (SL)
EXT int xms_objectschart;
EXT int xms_p_background;
EXT int xms_s_background;
*/

//UTC time stuff (SL)
/*
EXT int useUTC;
EXT void TestForUTC();
*/


//Methods used for & by the new temperature code (SL)
//Distances should be in centidyams (the default, make sure no scaling factors are applied)
//Temperatures are in celsius, though the math is internally done with kelvin.
EXT double GetStarMass(Word starClass, float starRay, double starX);
EXT double GetStarSurfaceTemperature(Word starClass, float starRay, double starMass);
EXT void PrecalcTemperatureTransmission(double ray, double surfaceTemp);
EXT double GetRawTemperatureAt(double distance);
EXT double GetOrbitingTemperatureAt(double distance);


//Other stuff, generally needed for multiplayer or other features (SL)
EXT void Pause();
EXT Word __cdecl DebugPrintf(Word toScreen, const char * format, ...);

//Determines the length of a file, stores the result in 'outvar'.
#define FileLength(outvar,file) \
	long filelength_pos = ftell(file);\
	fseek(file, 0, SEEK_END);\
	long filelength_len = ftell(file);\
	fseek(file, filelength_pos, SEEK_SET);\
	outvar=filelength_len;

EXT void Multiplayer();
EXT void DrawMultiplayerVehicles();
EXT void SendInfoTo(Word id);
EXT void SendRequestInfo();
EXT void SendInfo();
EXT void __cdecl RunCommand(const char * format, ...);
EXT void RecordXTime();	//records the time of the last x command.

EXT void RequestServerTime();		//Used by the irc-server-time code (SL):


EXT void FitOutHudBuffer(Word min, Word max);
EXT FastBool IsNaN(long double value);
EXT void ReadCommFile(FastBool deleteIt);

EXT void TargetParsisOrStar();
EXT void tavola_colori_brightness (Uchar *nuova_tavolozza,
		    Uword colore_di_partenza, Uword nr_colori,
		    char filtro_rosso, char filtro_verde, char filtro_blu, char brightness);
EXT Word MixColors (Uchar *orig_tavolozza, Uchar *nuova_tavolozza,
		    Uword colore_di_partenza, Uword nr_colori,
		    Word filtro, Word brightness);
EXT void ShadeMatrix (Uchar *palette, Word colorbase, Word numElements, Word numTransitionShades, Word numColors, char *terrain_color_feed);
EXT Dword MixSeeds(Dword global, Word lon, char lat);
EXT void CalculateTerrainTypes(Word replaceMap, Word logical_id, Uchar * background);
/*struct TerrainType {
	char sctype;
	short moisture;
	short altitude;
	char altitudeVariation;	//0 is normal, 1 is hilly, 2 is mountaineous, 3 is the mountain top.
};*/
EXT Word GetTerrainType(Word rawAlbedoParam, Word logical_id, Uchar * background, Word lat, Word lon, Dword ptr);
EXT double WrappedDist(Dword a, Dword b, Dword min, Dword max);
EXT void WriteTerrainType(char sctype, FastBool simplify);
EXT void SetFelisianPlanetColors(float *fr, float *fg, float *fb, float tr, float tg, float tb, float br, float bg, float bb, Word sctype);
EXT void cacti (float x, float y, float z, Dword depth);
EXT void build_cacti (float x, float y, float z,
			 float scaling, float reduction, float globalwidth,
			 Dword layers, Dword divisions, float distance_from_perfection,
			 Uchar rootcolormask, Uchar leafcolormask,
			 float branchdetail, char isrootnode, char occurrence);
EXT Dword getSectorCoords(double x, double y, double z, Dword *sx, Dword *sy, Dword *sz);
EXT FastBool isthere3(Dword sect_x, Dword sect_y, Dword sect_z);
EXT Dword valueMix;
EXT void * customMalloc(int size, char* name);
EXT void bufferCheck(char * filename, int line);
EXT double DebugSqrt(double x, char maybefar * filename, int line);
#endif