from __future__ import division
import os, sys, os.path, string
import cPickle
import getpass
import telnetlib
import time
import socket
import threading
from threading import Thread, Event, Lock

basefolder = 'C:/noctis'
sourcefolders = ['nosource', 'source']
copyFiles = ['.cs', '.h', '.hpp', '.cpp']

class Data:
	def __init__(self):
		self.lines=0
		self.codelines=0
		self.files=0
	def Add(self, data):
		self.lines+=data.lines
		self.codelines+=data.codelines
		self.files+=data.files
		
def main():
	globalData = Data()
	for subPath in sourcefolders:
		subfolderData = Data()
		files=os.listdir(basefolder+'/'+subPath)
		for file in files:
			file = file.lower()
			fileData = Data()
			for curSearchString in copyFiles:
				if (curSearchString==None and file.find('.')==-1) or (curSearchString!=None and file[-len(curSearchString):]==curSearchString):
					backup(fileData, basefolder, subPath, file)
					if (fileData.lines>0):
						print "\t\tIn "+file+": "+str(fileData.lines)+" lines, "+str(fileData.codelines)+" code lines. "+str(int(100*fileData.codelines/fileData.lines))+"% code lines."
						subfolderData.Add(fileData)
						globalData.Add(fileData)
		print "\tIn "+subPath+": "+str(subfolderData.lines)+" lines, "+str(subfolderData.codelines)+" code lines, in "+str(subfolderData.files)+" files."
	print "Total: "+str(globalData.lines)+" lines, "+str(globalData.codelines)+" code lines, in "+str(globalData.files)+" files."
	
def backup(data, basefolder, subPath, file):
	try:
		curFile=open(basefolder+'/'+subPath+'/'+file,'rt')
	except IOError:
		return
	
	lines = curFile.readlines()
	incomment=0
	for line in lines:
		line=line.strip()
		if (len(line)>1):
			data.lines+=1
			if (incomment):
				pos = line.find('*/')
				if (pos>-1):
					line=line[pos+2:]
					incomment=0
					line=line.strip()
				#if (file=='calchue.hpp'):
				#	print 'line was incomment, is now "'+line+'" and incomment='+str(incomment)
				
			if ((not incomment) and len(line)>1):
				pos = line.find('//')
				if (pos>-1):
					line = line[0:pos].strip()
				
				pos = line.find('/*')
				if (pos>-1):
					pos2 = line.find('*/',pos)
					if (pos2>-1):
						line=(line[0:pos]+line[pos2+2:]).strip()
					else:
						incomment=1
						line=line[0:pos].strip()
				if len(line)>1:
					data.codelines+=1
				
				#if (file=='calchue.hpp'):
				#	print 'line was not incomment, is now "'+line+'" and incomment='+str(incomment)
				
	curFile.close()
	data.files+=1	
		
if __name__ == '__main__': main()