/*

	Noctis galactic guide / WHERE command.
	GOES Net Module.

	Modified Apr 19 2005 by SL: Updated for starmap3.
	

*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include "defs.h"
#include "modshare.hpp"

double 	object_id = 12345;
char   	object_label[25];
double 	s_object_id = 12345;
char   	s_object_label[25];

double	subject_id = 12345;
double  idscale = 0.00001;

int 	i;
FILE * fh;
char	*file = "..\\DATA\\starmap3.map";

char	outbuffer[40];
char	textbuffer[40];
char	parbuffer[160];
char	nullbuffer[128];
char	objectname[21];
char	subjectname[21];
char	parentname[21];

void main ()
{
	CHECK_SITUATION;
	/*asm {	xor	ax, ax
		mov	es, ax
		cmp	byte ptr es:[0x449], 0x13
		je	startup }

	printf ("\nGalactic Organization of Explorers and Stardrifters (G.O.E.S)\n");
	printf ("-------------------------------------------------------------\n");
	printf ("This is a GOES NET module and must be run from a stardrifter.\n");
	printf ("Please use the onboard computer console to run this module.\n");
	printf ("\n\t- GOES NET onboard microsystem, EPOC 6011 REVISION 2\n");
	return;*/

	//startup:
	if (_argc<2) {
		msg ("________USAGE________");
		msg ("WHERE PLANETNAME");
		msg ("^^^^^^^^^^^^^^^^^^^^^");
		msg ("PLEASE RUN AGAIN,");
		msg ("SPECIFYING PARAMETERS");
		return;
	}
	else {
		msg ("  GOES GALACTIC MAP  ");
		msg (divider);
	}

	fh = fopen(file, "rb");
	if (fh == NULL) {
		msg ("STARMAP NOT AVAILABLE");
		return;
	}

	i = 2;
	strcpy (parbuffer, _argv[1]);
	while (i < _argc) {
		strcat (parbuffer, " ");
		strcat (parbuffer, _argv[i]);
		i++;
	}

	strcpy (objectname, parbuffer);
	
	long starmap3Len = 0;
	fseek(fh, 0, SEEK_END);
	starmap3Len = ftell(fh);
	fseek(fh, 0, SEEK_SET);
	Uword fileFormatVersion;
	Udword starmap3VersionHalf;
	fread(&fileFormatVersion, 2, 1, fh);
	fread(&starmap3VersionHalf, 4, 1, fh);
	fread(&starmap3VersionHalf, 4, 1, fh);
	
	int numNameChars = strlen (objectname);
	if (numNameChars > 20 || numNameChars <= 0) {
		msg ("INVALID OBJECT NAME.");
		return;
	}
	Dword matches = FindInStarmap (fh, starmap3Len, objectname, &sm3data);
	if (matches==1) {
		if (sm3data.retvalType==RETVAL_STAR) {
			msg ("THIS OBJECT IS A STAR");
			msg ("AND ITS POSITION CAN");
			msg ("BE DETERMINED USING");
			msg ("THE 'PAR' MODULE.");
		} else if (sm3data.retvalType==RETVAL_PLANET) {
			msg (objectname);
			msg ("IS PART OF THE");
			sprintf(outbuffer, "%.20s", sm3data.starname);
			msg (outbuffer);
			msg ("SYSTEM.");
		}
	}
	
	fclose (fh);
}