
void poly3d (float *x, float *y, float *z,
	     Uword nrv, Uchar colore)
{
	//return;
	#ifdef WINDOWS
	Udword _8n;
	#else
	Uword _8n;
	#endif
    Uchar ent = entity;
	#ifdef WINDOWS
	Udword nrvDW = nrv;
	#endif
	if (nrvDW<3 || nrvDW>4) return;

	// Rototraslazione dei vertici; i dati rimangono ancora 3d.

				doflag = 0;
				asm {
				#ifdef WINDOWS
					pushad
				#endif
					xor MAYBE_EDI, MAYBE_EDI
					xor MAYBE_ESI, MAYBE_ESI
				} vertex: asm {
					L_DWORD_PTR(es, MAYBE_EBX, z)
		   			fld dword ptr SEGVAR(es, MAYBE_EBX+MAYBE_ESI)
		   			fsub cam_z
					fst zz
					fmul opt_psinbeta
					L_DWORD_PTR(es, MAYBE_EBX, x)
		   			fld dword ptr SEGVAR(es, MAYBE_EBX+MAYBE_ESI)
		   			fsub cam_x
					fst xx
					fmul opt_pcosbeta
					faddp
					fstp dword ptr rxf[MAYBE_ESI]
					fld zz
					fmul opt_tcosbeta
					fld xx
					fmul opt_tsinbeta
					fsubp
					fst z2
					fmul opt_tcosalfa
					L_DWORD_PTR(es, MAYBE_EBX, y)
		   			fld dword ptr SEGVAR(es, MAYBE_EBX+MAYBE_ESI)
		   			fsub cam_y
					fst yy
					fmul opt_tsinalfa
					faddp
					fst dword ptr rzf[MAYBE_ESI]
					fcomp uneg
					fstsw ax
					fld yy
					fmul opt_pcosalfa
					fld z2
					fmul opt_psinalfa
					fsubp
					fstp dword ptr ryf[MAYBE_ESI]
					sahf
					jb rzf_min_uneg
					inc doflag
					mov byte ptr rwf[MAYBE_EDI], 1
					jmp convert }
		    rzf_min_uneg:
		    	asm   mov byte ptr rwf[MAYBE_EDI], 0
		    convert:
		    	asm {
		    		add MAYBE_ESI, 4
					inc MAYBE_EDI
					#ifdef WINDOWS
		    		cmp edi, nrvDW
		    		#else
		    		cmp di, nrv
					#endif
					je end_convert
					jmp vertex }
	
		    end_convert:
					if (!doflag) {
						#ifdef WINDOWS
						asm popad
						#endif
						return;
					}

	// Fast-load per poligoni completamente visibili.

					if (doflag==nrv) {
						asm {
							xor MAYBE_ESI, MAYBE_ESI
							mov cx, nrv
							mov vr2, cx }
					load:
						   asm {
							MOV_EAX_DWORD_PTR rxf[MAYBE_ESI]
							MOV_EBX_DWORD_PTR ryf[MAYBE_ESI]
							MOV_EDX_DWORD_PTR rzf[MAYBE_ESI]
							MOV_DWORD_PTR ultima_x[MAYBE_ESI], MAYBE_EAX
							MOV_DWORD_PTR ultima_y[MAYBE_ESI], MAYBE_EBX
							MOV_DWORD_PTR ultima_z[MAYBE_ESI], MAYBE_EDX
							add MAYBE_ESI, 4
							dec MAYBE_ECX
							jnz load }
						goto to_2d;
					}

	/* Conversione punti alle spalle dell'osservatore
	   rispetto al piano dello schermo. */

					asm {   
						mov vr, 0
						xor MAYBE_EDI, MAYBE_EDI
						mov dx, nrv
						dec dx }
			     the_for_1: asm {
			     		MOVZX_MAYBE_ESI, vr
					 	cmp byte ptr rwf[MAYBE_ESI], 0
						
						je CONT1
						jmp bypass }
			      CONT1:    asm {
			      		mov ax, vr
						sub ax, 1
						jnc pvert1ok
						mov pvert, dx
						jmp pvert1no }
			      pvert1ok: asm     mov pvert, ax
			      pvert1no: asm {   mov ax, vr
						inc ax
						cmp ax, dx
						jbe nvert1ok
						mov nvert, 0
						jmp nvert1no }
			      nvert1ok: asm     mov nvert, ax
			      nvert1no: asm {
			      		MOVZX_MAYBE_ESI, pvert
						cmp byte ptr rwf[MAYBE_ESI], 0
						je ctrl1
						jmp JMPR11 }
			      ctrl1:    asm {
			      		MOVZX_MAYBE_ESI, nvert
						cmp byte ptr rwf[MAYBE_ESI], 0
						jne JMPR11
						jmp STOP1 }
			      JMPR11:   asm {   mov bx, vr
						shl bx, 2
						MOVZX_MAYBE_ESI, pvert
						mov al, byte ptr rwf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						add al, byte ptr rwf[MAYBE_ESI]
						cmp al, 2
						je if11
						jmp else11 }
			      if11:     asm {
			      		shl pvert, 2
						shl nvert, 2
						MOVZX_MAYBE_ESI, bx
						fld dword ptr rzf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fcomp dword ptr rzf[MAYBE_ESI]
						fstsw ax
						sahf
						jne if12
						jmp else12 }
			      if12:     asm {
			      		fld dword ptr uneg
						fsub dword ptr rzf[MAYBE_ESI]
						fld dword ptr rzf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, bx
						fsubr dword ptr rzf[MAYBE_ESI]
						fdivp
						fst zk
						fld dword ptr rxf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fsub dword ptr rxf[MAYBE_ESI]
						fmulp
						fadd dword ptr rxf[MAYBE_ESI]
						fstp dword ptr ultima_x[MAYBE_EDI]
						fld zk
						MOVZX_MAYBE_ESI, bx
						fld dword ptr ryf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fsub dword ptr ryf[MAYBE_ESI]
						fmulp
						fadd dword ptr ryf[MAYBE_ESI]
						fstp dword ptr ultima_y[MAYBE_EDI]
						jmp JMPR12 }
			      else12:   asm {
			      		MOVZX_MAYBE_ESI, bx
						MOV_EAX_DWORD_PTR rxf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_x[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR ryf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_y[MAYBE_EDI], MAYBE_EAX }
			      JMPR12:   asm {
			      		MOV_EAX_DWORD_PTR uneg
						MOV_DWORD_PTR ultima_z[MAYBE_EDI], MAYBE_EAX
						MOVZX_MAYBE_ESI, bx
						fld dword ptr rzf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fcomp dword ptr rzf[MAYBE_ESI]
						fstsw ax
						sahf
						jne neq1
						jmp eq1 }
			      neq1:     asm {   fld dword ptr uneg
						fsub dword ptr rzf[MAYBE_ESI]
						fld dword ptr rzf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, bx
						fsubr dword ptr rzf[MAYBE_ESI]
						fdivp
						fst zk
						fld dword ptr rxf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fsub dword ptr rxf[MAYBE_ESI]
						fmulp
						fadd dword ptr rxf[MAYBE_ESI]
						fstp dword ptr ultima_x[MAYBE_EDI+4]
						fld zk
						MOVZX_MAYBE_ESI, bx
						fld dword ptr ryf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fsub dword ptr ryf[MAYBE_ESI]
						fmulp
						fadd dword ptr ryf[MAYBE_ESI]
						fstp dword ptr ultima_y[MAYBE_EDI+4]
						jmp JMPR13 }
			      eq1:      asm {
			      		MOVZX_MAYBE_ESI, bx
						MOV_EAX_DWORD_PTR rxf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_x[MAYBE_EDI+4], MAYBE_EAX
						MOV_EAX_DWORD_PTR ryf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_y[MAYBE_EDI+4], MAYBE_EAX }
			      JMPR13:   asm {
			      		MOV_EAX_DWORD_PTR uneg
						MOV_DWORD_PTR ultima_z[MAYBE_EDI+4], MAYBE_EAX
						add MAYBE_EDI, 8
						jmp STOP1 }
			      else11:   asm {
			      		MOVZX_MAYBE_ESI, pvert
						cmp byte ptr rwf[MAYBE_ESI], 0
						jne vpvert1
						mov ax, nvert
						mov vvert, ax
						jmp vnvert1 }
			      vpvert1:  asm {   mov ax, pvert
						mov vvert, ax }
			      vnvert1:  asm {   shl vvert, 2
						MOVZX_MAYBE_ESI, bx
						fld dword ptr rzf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fcomp dword ptr rzf[MAYBE_ESI]
						fstsw ax
						sahf
						jne neq2
						jmp eq2 }
			      neq2:     asm {   fld dword ptr uneg
						fsub dword ptr rzf[MAYBE_ESI]
						fld dword ptr rzf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, bx
						fsubr dword ptr rzf[MAYBE_ESI]
						fdivp
						fst zk
						fld dword ptr rxf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fsub dword ptr rxf[MAYBE_ESI]
						fmulp
						fadd dword ptr rxf[MAYBE_ESI]
						fstp dword ptr ultima_x[MAYBE_EDI]
						fld zk
						MOVZX_MAYBE_ESI, bx
						fld dword ptr ryf[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fsub dword ptr ryf[MAYBE_ESI]
						fmulp
						fadd dword ptr ryf[MAYBE_ESI]
						fstp dword ptr ultima_y[MAYBE_EDI]
						jmp JMPR14 }
			      eq2:      asm {   MOVZX_MAYBE_ESI, bx
						MOV_EAX_DWORD_PTR rxf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_x[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR ryf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_y[MAYBE_EDI], MAYBE_EAX }
			      JMPR14:   asm {
			      		MOV_EAX_DWORD_PTR uneg
						MOV_DWORD_PTR ultima_z[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4
						jmp STOP1 }
			      bypass:   asm {   shl MAYBE_ESI, 2
						MOV_EAX_DWORD_PTR rxf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_x[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR ryf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_y[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR rzf[MAYBE_ESI]
						MOV_DWORD_PTR ultima_z[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4 }
			      STOP1:    asm {   inc vr
						mov ax, vr
						cmp ax, nrv
						jnb cutting_end_1
						jmp the_for_1 }

			 cutting_end_1: asm {
			 			mov MAYBE_EAX, MAYBE_EDI
						shr ax, 2
						mov vr2, ax
						}

				if (vr2<3) {
					#ifdef WINDOWS
					asm popad
					#endif
					return;
				}

	   // Queste sono le proiezioni prospettiche da 3d a 2d.
	   // E` stato incluso in data 6.12.97 anche un piccolo esame
	   // dei minimi e massimi grafici. Questo fa s che i poligoni
	   // che rientrano nei limiti del video non vengano esaminati
	   // dalle funzioni di clipping 2-d. E` pi intelligente.
	   // Prima d'ora, il ciclo di ricerca minimi-massimi era in fondo,
	   // e veniva eseguito dopo il clipping 2d, che per  lungo
	   // e complicato: non  quindi una cosa da fare sempre.

				 to_2d: asm {
				 		MOV_EAX_DWORD_PTR lbxl
						MOV_EBX_DWORD_PTR lbyl
						MOV_ECX_DWORD_PTR ubxl
						MOV_EDX_DWORD_PTR ubyl
						MOVZX_MAYBE_ESI, vr2
						dec MAYBE_ESI
						shl MAYBE_ESI, 2
						mov MAYBE_EDI, MAYBE_ESI
						add MAYBE_EDI, MAYBE_ESI
						mov _8n, MAYBE_EDI }
			     projector: asm {   fld uno
						fdiv dword ptr ultima_z[MAYBE_ESI]
						fld st(0)
						fmul dword ptr ultima_x[MAYBE_ESI]
						fadd dword ptr x_centro_f
						fst dword ptr video_x0[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI]
						CMP_DWORD_PTR mp[MAYBE_EDI], MAYBE_ECX
						jnl outr_1
						MOV_ECX_DWORD_PTR mp[MAYBE_EDI]
						}
			     outr_1:	asm {
			     		CMP_DWORD_PTR mp[MAYBE_EDI], MAYBE_EAX
			     		
						jle outr_2
						MOV_EAX_DWORD_PTR mp[MAYBE_EDI]
						}
			     outr_2:	asm {
			     		fmul dword ptr ultima_y[MAYBE_ESI]
						fadd dword ptr y_centro_f
						fst dword ptr video_y0[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+4]
						CMP_DWORD_PTR mp[MAYBE_EDI+4], MAYBE_EDX
						jnl outr_3
						MOV_EDX_DWORD_PTR mp[MAYBE_EDI+4]
					}
			     outr_3:	asm {
			     		CMP_DWORD_PTR mp[MAYBE_EDI+4], MAYBE_EBX
						jle outr_4
						MOV_EBX_DWORD_PTR mp[MAYBE_EDI+4]
						}
			     outr_4:	asm {
			     		sub MAYBE_EDI, 8
						sub MAYBE_ESI, 4
						jnc projector
						mov max_x, ax
						mov max_y, bx
						mov min_x, cx
						mov min_y, dx
						xor MAYBE_ESI, MAYBE_ESI
						CMP_EAX_DWORD_PTR ubxl
						jl ranged1
						inc MAYBE_ESI
						mov max_x, ubx
						}
			     ranged1:	asm {
			     		CMP MAYBE_EBX, MAYBE_DWORD_PTR ubyl
						jl ranged2
						inc MAYBE_ESI
						mov max_y, uby
						}
			     ranged2:	asm {
			     		CMP MAYBE_ECX, MAYBE_DWORD_PTR lbxl
			     		jnl ranged3
						inc MAYBE_ESI
						mov min_x, lbx
						}
			     ranged3:	asm {
			     		CMP MAYBE_EDX, MAYBE_DWORD_PTR lbyl
			     		jnl ranged4
						inc MAYBE_ESI
						mov min_y, lby
						}
			     ranged4:	asm {
			     		test MAYBE_ESI, MAYBE_ESI
						jnz yes_clip
						jmp drawb
						}

	   /* Conversione dei punti che risiedono al di fuori dell'area
	      visibile. Questi punti devono essere ridimensionati per
	      rientrare in tale area per evitare poligoni troppo grandi,
	      che oltre a rallentare notevolmente il tracciamento provocano
	      il blocco di sistema invadendo aree di memoria non-video.
	      In questa sezione i dati sui vertici del poligono da tracciare
	      vengono rimaneggiati a livello bidimensionale, aggiungendo
	      eventuali vertici per "ritagliare" solo la parte di poligono
	      visibile. */

	   // Lato superiore del video.

			      yes_clip: asm {   mov vr, 0
						xor MAYBE_EDI, MAYBE_EDI
						mov dx, vr2
						dec dx }
			      the_for_2:asm {   MOVZX_MAYBE_ESI, vr
						shl MAYBE_ESI, 2
						fld dword ptr video_y0[MAYBE_ESI]
						fcomp dword ptr lbyf
						fstsw ax
						sahf
						jb if21
						jmp else21 }
			      if21:     asm {
				      	mov MAYBE_EBX, MAYBE_ESI
				      	mov ax, vr
						sub ax, 1
						jnc pvert2ok
						mov pvert, dx
						jmp pvert2no }
			      pvert2ok: asm     mov pvert, ax
			      pvert2no: asm {   mov ax, vr
						inc ax
						cmp ax, dx
						jbe nvert2ok
						mov nvert, 0
						jmp nvert2no }
			      nvert2ok: asm     mov nvert, ax
			      nvert2no: asm {   shl pvert, 2
						shl nvert, 2
						MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_y0[MAYBE_ESI]
						fcomp dword ptr lbyf
						fstsw ax
						sahf
						jae CONT2
						MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_y0[MAYBE_ESI]
						fcomp dword ptr lbyf
						fstsw ax
						sahf
						jae CONT2
						jmp STOP2 }
			      CONT2:    asm {   MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_y0[MAYBE_ESI]
						fcomp dword ptr lbyf
						fstsw ax
						sahf
						jae ctrl22
						jmp else22 }
			      ctrl22:   asm {   MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_y0[MAYBE_ESI]
						fcomp dword ptr lbyf
						fstsw ax
						sahf
						jae if22
						jmp else22 }
			      if22:     asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		fld dword ptr video_y0[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fcomp dword ptr video_y0[MAYBE_ESI]
						fstsw ax
						sahf
						jne if23
						jmp else23 }
			      if23:     asm {   fld dword ptr lbyf
						fsub dword ptr video_y0[MAYBE_ESI]
						fld dword ptr video_y0[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		fsubr dword ptr video_y0[MAYBE_ESI]
						fdivp
						fld dword ptr video_x0[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fsub dword ptr video_x0[MAYBE_ESI]
						fmulp
						fadd dword ptr video_x0[MAYBE_ESI]
						fstp dword ptr video_x1[MAYBE_EDI]
						jmp JMPR23 }
			      else23:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		MOV_EAX_DWORD_PTR video_x0[MAYBE_ESI]
						MOV_DWORD_PTR video_x1[MAYBE_EDI], MAYBE_EAX 
						}
			      JMPR23:   asm {
			      	
			      		MOV_EAX_DWORD_PTR lbyf
						MOV_DWORD_PTR video_y1[MAYBE_EDI], MAYBE_EAX
						mov MAYBE_ESI, MAYBE_EBX
						fld dword ptr video_y0[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fcomp dword ptr video_y0[MAYBE_ESI]
						fstsw ax
						sahf
						jne if24
						jmp else24 }
			      if24:     asm {   fld dword ptr lbyf
						fsub dword ptr video_y0[MAYBE_ESI]
						fld dword ptr video_y0[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		fsubr dword ptr video_y0[MAYBE_ESI]
						fdivp
						fld dword ptr video_x0[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fsub dword ptr video_x0[MAYBE_ESI]
						fmulp
						fadd dword ptr video_x0[MAYBE_ESI]
						fstp dword ptr video_x1[MAYBE_EDI+4]
						jmp JMPR22 }
			      else24:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		MOV_EAX_DWORD_PTR video_x0[MAYBE_ESI]
						MOV_DWORD_PTR video_x1[MAYBE_EDI+4], MAYBE_EAX
						}
			      JMPR22:   asm {
			      		MOV_EAX_DWORD_PTR lbyf
						MOV_DWORD_PTR video_y1[MAYBE_EDI+4], MAYBE_EAX
						add MAYBE_EDI, 8
						jmp STOP2 }
			      else22:   asm {
			      		MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_y0[MAYBE_ESI]
						fcomp dword ptr lbyf
						fstsw ax
						sahf
						jb vnvert2
						mov ax, pvert
						mov vvert, ax
						jmp vpvert2 }
			      vnvert2:  asm {   mov ax, nvert
						mov vvert, ax }
			      vpvert2:  asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		fld dword ptr video_y0[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fcomp dword ptr video_y0[MAYBE_ESI]
						fstsw ax
						sahf
						jne if25
						jmp else35 }
			      if25:     asm {   fld dword ptr lbyf
						fsub dword ptr video_y0[MAYBE_ESI]
						fld dword ptr video_y0[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		fsubr dword ptr video_y0[MAYBE_ESI]
						fdivp
						fld dword ptr video_x0[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fsub dword ptr video_x0[MAYBE_ESI]
						fmulp
						fadd dword ptr video_x0[MAYBE_ESI]
						fstp dword ptr video_x1[MAYBE_EDI]
						jmp JMPR21 }
			      else25:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						MOV_EAX_DWORD_PTR video_x0[MAYBE_ESI]
						MOV_DWORD_PTR video_x1[MAYBE_EDI], MAYBE_EAX
						}
			      JMPR21:   asm {
			      		MOV_EAX_DWORD_PTR lbyf
						MOV_DWORD_PTR video_y1[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4
						jmp STOP2 }
			      else21:   asm {
			      		MOV_EAX_DWORD_PTR video_y0[MAYBE_ESI]
						MOV_DWORD_PTR video_y1[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR video_x0[MAYBE_ESI]
						MOV_DWORD_PTR video_x1[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4 }
			      STOP2:    asm {   inc vr
						mov ax, vr
						cmp ax, vr2
						jnb cutting_end_2
						jmp the_for_2 }

			 cutting_end_2: asm {
			 			mov MAYBE_EAX, MAYBE_EDI
						shr ax, 2
						mov vr3, ax
						}

					if (vr3<3) {
						#ifdef WINDOWS
						asm popad
						#endif
						return;
					}

	   // Lato inferiore del video.

					asm {   mov vr, 0
						xor MAYBE_EDI, MAYBE_EDI
						mov dx, vr3
						dec dx }
			      the_for_3:asm {   MOVZX_MAYBE_ESI, vr
						shl MAYBE_ESI, 2
						fld dword ptr video_y1[MAYBE_ESI]
						fcomp dword ptr ubyf
						fstsw ax
						sahf
						ja if31
						jmp else31 }
			      if31:     asm {
			      		mov MAYBE_EBX, MAYBE_ESI
			      		
						mov ax, vr
						sub ax, 1
						jnc pvert3ok
						mov pvert, dx
						jmp pvert3no }
			      pvert3ok: asm     mov pvert, ax
			      pvert3no: asm {   mov ax, vr
						inc ax
						cmp ax, dx
						jbe nvert3ok
						mov nvert, 0
						jmp nvert3no }
			      nvert3ok: asm     mov nvert, ax
			      nvert3no: asm {   shl pvert, 2
						shl nvert, 2
						MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_y1[MAYBE_ESI]
						fcomp dword ptr ubyf
						fstsw ax
						sahf
						jbe CONT3
						mov si, nvert
						fld dword ptr video_y1[MAYBE_ESI]
						fcomp dword ptr ubyf
						fstsw ax
						sahf
						jbe CONT3
						jmp STOP3 }
			      CONT3:    asm {   MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_y1[MAYBE_ESI]
						fcomp dword ptr ubyf
						fstsw ax
						sahf
						jbe ctrl32
						jmp else32 }
			      ctrl32:   asm {   MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_y1[MAYBE_ESI]
						fcomp dword ptr ubyf
						fstsw ax
						sahf
						jbe if32
						jmp else32 }
			      if32:     asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_y1[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fcomp dword ptr video_y1[MAYBE_ESI]
						fstsw ax
						sahf
						jne if33
						jmp else33 }
			      if33:     asm {   fld dword ptr ubyf
						fsub dword ptr video_y1[MAYBE_ESI]
						fld dword ptr video_y1[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		fsubr dword ptr video_y1[MAYBE_ESI]
						fdivp
						fld dword ptr video_x1[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fsub dword ptr video_x1[MAYBE_ESI]
						fmulp
						fadd dword ptr video_x1[MAYBE_ESI]
						fstp dword ptr video_x2[MAYBE_EDI]
						jmp JMPR33 }
			      else33:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						MOV_EAX_DWORD_PTR video_x1[MAYBE_ESI]
						MOV_DWORD_PTR video_x2[MAYBE_EDI], MAYBE_EAX
						}
			      JMPR33:   asm {
			      		MOV_EAX_DWORD_PTR ubyf
						MOV_DWORD_PTR video_y2[MAYBE_EDI], MAYBE_EAX
						mov MAYBE_ESI, MAYBE_EBX
			      		fld dword ptr video_y1[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fcomp dword ptr video_y1[MAYBE_ESI]
						fstsw ax
						sahf
						jne if34
						jmp else34 }
			      if34:     asm {   fld dword ptr ubyf
						fsub dword ptr video_y1[MAYBE_ESI]
						fld dword ptr video_y1[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		fsubr dword ptr video_y1[MAYBE_ESI]
						fdivp
						fld dword ptr video_x1[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fsub dword ptr video_x1[MAYBE_ESI]
						fmulp
						fadd dword ptr video_x1[MAYBE_ESI]
						fstp dword ptr video_x2[MAYBE_EDI+4]
						jmp JMPR32 }
			      else34:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		MOV_EAX_DWORD_PTR video_x1[MAYBE_ESI]
						MOV_DWORD_PTR video_x2[MAYBE_EDI+4], MAYBE_EAX
						}
			      JMPR32:   asm {
			      		MOV_EAX_DWORD_PTR ubyf
						MOV_DWORD_PTR video_y2[MAYBE_EDI+4], MAYBE_EAX
						add MAYBE_EDI, 8
						jmp STOP3 }
			      else32:   asm {   MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_y1[MAYBE_ESI]
						fcomp dword ptr ubyf
						fstsw ax
						sahf
						ja vnvert3
						mov ax, pvert
						mov vvert, ax
						jmp vpvert3 }
			      vnvert3:  asm {   mov ax, nvert
						mov vvert, ax }
			      vpvert3:  asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_y1[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fcomp dword ptr video_y1[MAYBE_ESI]
						fstsw ax
						sahf
						jne if35
						jmp else35 }
			      if35:     asm {   fld dword ptr ubyf
						fsub dword ptr video_y1[MAYBE_ESI]
						fld dword ptr video_y1[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
						fsubr dword ptr video_y1[MAYBE_ESI]
						fdivp
						fld dword ptr video_x1[MAYBE_ESI]
						mov si, vvert
						fsub dword ptr video_x1[MAYBE_ESI]
						fmulp
						fadd dword ptr video_x1[MAYBE_ESI]
						fstp dword ptr video_x2[MAYBE_EDI]
						jmp JMPR31 }
			      else35:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
						MOV_EAX_DWORD_PTR video_x1[MAYBE_ESI]
						MOV_DWORD_PTR video_x2[MAYBE_EDI], MAYBE_EAX
						}
			      JMPR31:   asm {
			      		MOV_EAX_DWORD_PTR ubyf
						MOV_DWORD_PTR video_y2[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4
						jmp STOP3 }
			      else31:   asm {
			      		MOV_EAX_DWORD_PTR video_y1[MAYBE_ESI]
						MOV_DWORD_PTR video_y2[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR video_x1[MAYBE_ESI]
						MOV_DWORD_PTR video_x2[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4 }
			      STOP3:    asm {   inc vr
						mov ax, vr
						cmp ax, vr3
						jnb cutting_end_3
						jmp the_for_3 }

			 cutting_end_3: asm {
			 			mov MAYBE_EAX, MAYBE_EDI
						shr ax, 2
						mov vr4, ax
						}

					if (vr4<3) {
						#ifdef WINDOWS
						asm popad
						#endif
						return;
					}

	   // Lato sinistro del video.

					asm {   mov vr, 0
						xor MAYBE_EDI, MAYBE_EDI
						mov dx, vr4
						dec dx }
			      the_for_4:asm {
			      		MOVZX_MAYBE_ESI, vr
						shl MAYBE_ESI, 2
						fld dword ptr video_x2[MAYBE_ESI]
						fcomp dword ptr lbxf
						fstsw ax
						sahf
						jb if41
						jmp else41 }
			      if41:     asm {
			      		mov MAYBE_EBX, MAYBE_ESI
			      		mov ax, vr
						sub ax, 1
						jnc pvert4ok
						mov pvert, dx
						jmp pvert4no }
			      pvert4ok: asm     mov pvert, ax
			      pvert4no: asm {   mov ax, vr
						inc ax
						cmp ax, dx
						jbe nvert4ok
						mov nvert, 0
						jmp nvert4no }
			      nvert4ok: asm     mov nvert, ax
			      nvert4no: asm {   shl pvert, 2
						shl nvert, 2
						MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_x2[MAYBE_ESI]
						fcomp dword ptr lbxf
						fstsw ax
						sahf
						jae CONT4
						MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_x2[MAYBE_ESI]
						fcomp dword ptr lbxf
						fstsw ax
						sahf
						jae CONT4
						jmp STOP4 }
			      CONT4:    asm {
			      		MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_x2[MAYBE_ESI]
						fcomp dword ptr lbxf
						fstsw ax
						sahf
						jae ctrl42
						jmp else42 }
			      ctrl42:   asm {
			      		MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_x2[MAYBE_ESI]
						fcomp dword ptr lbxf
						fstsw ax
						sahf
						jae if42
						jmp else42 }
			      if42:     asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_x2[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fcomp dword ptr video_x2[MAYBE_ESI]
						fstsw ax
						sahf
						jne if43
						jmp else43 }
			      if43:     asm {   fld dword ptr lbxf
						fsub dword ptr video_x2[MAYBE_ESI]
						fld dword ptr video_x2[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fsubr dword ptr video_x2[MAYBE_ESI]
						fdivp
						fld dword ptr video_y2[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fsub dword ptr video_y2[MAYBE_ESI]
						fmulp
						fadd dword ptr video_y2[MAYBE_ESI]
						fstp dword ptr video_y3[MAYBE_EDI]
						jmp JMPR43 }
			      else43:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						MOV_EAX_DWORD_PTR video_y2[MAYBE_ESI]
						MOV_DWORD_PTR video_y3[MAYBE_EDI], MAYBE_EAX
						}
			      JMPR43:   asm {
			      		MOV_EAX_DWORD_PTR lbxf
						MOV_DWORD_PTR video_x3[MAYBE_EDI], MAYBE_EAX
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_x2[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fcomp dword ptr video_x2[MAYBE_ESI]
						fstsw ax
						sahf
						jne if44
						jmp else44 }
			      if44:     asm {   fld dword ptr lbxf
						fsub dword ptr video_x2[MAYBE_ESI]
						fld dword ptr video_x2[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fsubr dword ptr video_x2[MAYBE_ESI]
						fdivp
						fld dword ptr video_y2[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fsub dword ptr video_y2[MAYBE_ESI]
						fmulp
						fadd dword ptr video_y2[MAYBE_ESI]
						fstp dword ptr video_y3[MAYBE_EDI+4]
						jmp JMPR42 }
			      else44:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						MOV_EAX_DWORD_PTR video_y2[MAYBE_ESI]
						MOV_DWORD_PTR video_y3[MAYBE_EDI+4], MAYBE_EAX }
			      JMPR42:   asm {   MOV_EAX_DWORD_PTR lbxf
						MOV_DWORD_PTR video_x3[MAYBE_EDI+4], MAYBE_EAX
						add MAYBE_EDI, 8
						jmp STOP4 }
			      else42:   asm {   MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_x2[MAYBE_ESI]
						fcomp dword ptr lbxf
						fstsw ax
						sahf
						jb vnvert4
						mov ax, pvert
						mov vvert, ax
						jmp vpvert4 }
			      vnvert4:  asm {   mov ax, nvert
						mov vvert, ax }
			      vpvert4:  asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_x2[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fcomp dword ptr video_x2[MAYBE_ESI]
						fstsw ax
						sahf
						jne if45
						jmp else45 }
			      if45:     asm {   fld dword ptr lbxf
						fsub dword ptr video_x2[MAYBE_ESI]
						fld dword ptr video_x2[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fsubr dword ptr video_x2[MAYBE_ESI]
						fdivp
						fld dword ptr video_y2[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fsub dword ptr video_y2[MAYBE_ESI]
						fmulp
						fadd dword ptr video_y2[MAYBE_ESI]
						fstp dword ptr video_y3[MAYBE_EDI]
						jmp JMPR41 }
			      else45:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						MOV_EAX_DWORD_PTR video_y2[MAYBE_ESI]
						MOV_DWORD_PTR video_y3[MAYBE_EDI], MAYBE_EAX }
			      JMPR41:   asm {   MOV_EAX_DWORD_PTR lbxf
						MOV_DWORD_PTR video_x3[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4
						jmp STOP4 }
			      else41:   asm {
			      		MOV_EAX_DWORD_PTR video_x2[MAYBE_ESI]
						MOV_DWORD_PTR video_x3[MAYBE_EDI], MAYBE_EAX
						MOV_EAX_DWORD_PTR video_y2[MAYBE_ESI]
						MOV_DWORD_PTR video_y3[MAYBE_EDI], MAYBE_EAX
						add MAYBE_EDI, 4 }
			      STOP4:    asm {   inc vr
						mov ax, vr
						cmp ax, vr4
						jnb cutting_end_4
						jmp the_for_4 }

			 cutting_end_4: asm {
			 			mov MAYBE_EAX, MAYBE_EDI
						shr ax, 2
						mov vr5, ax }

					if (vr5<3) {
						#ifdef WINDOWS
						asm popad
						#endif
						return;
					}

	   // Lato destro del video.

					asm {   mov vr, 0
						xor MAYBE_EDI, MAYBE_EDI // vr6 * 4
						mov dx, vr5
						dec dx } // vr5 - 1
			      the_for_5:asm {   MOVZX_MAYBE_ESI, vr
						shl MAYBE_ESI, 2
						fld dword ptr video_x3[MAYBE_ESI]
						fcomp dword ptr ubxf
						fstsw ax
						sahf
						ja if51
						jmp else51 }
			      if51:     asm {
			      		mov MAYBE_EBX, MAYBE_ESI // costante vr * 4
						mov ax, vr
						sub ax, 1
						jnc pvert5ok
						mov pvert, dx
						jmp pvert5no }
			      pvert5ok: asm     mov pvert, ax
			      pvert5no: asm {   mov ax, vr
						inc ax
						cmp ax, dx
						jbe nvert5ok
						mov nvert, 0
						jmp nvert5no }
			      nvert5ok: asm     mov nvert, ax
			      nvert5no: asm {   shl pvert, 2
						shl nvert, 2
						MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_x3[MAYBE_ESI]
						fcomp dword ptr ubxf
						fstsw ax
						sahf
						jbe CONT5
						MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_x3[MAYBE_ESI]
						fcomp dword ptr ubxf
						fstsw ax
						sahf
						jbe CONT5
						jmp STOP5 }
			      CONT5:    asm {   MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_x3[MAYBE_ESI]
						fcomp dword ptr ubxf
						fstsw ax
						sahf
						jbe ctrl52
						jmp else52 }
			      ctrl52:   asm {   MOVZX_MAYBE_ESI, nvert
						fld dword ptr video_x3[MAYBE_ESI]
						fcomp dword ptr ubxf
						fstsw ax
						sahf
						jbe if52
						jmp else52 }
			      if52:     asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_x3[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fcomp dword ptr video_x3[MAYBE_ESI]
						fstsw ax
						sahf
						jne if53
						jmp else53 }
			      if53:     asm {   fld dword ptr ubxf
						fsub dword ptr video_x3[MAYBE_ESI]
						fld dword ptr video_x3[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fsubr dword ptr video_x3[MAYBE_ESI]
						fdivp
						fld dword ptr video_y3[MAYBE_ESI]
						MOVZX_MAYBE_ESI, pvert
						fsub dword ptr video_y3[MAYBE_ESI]
						fmulp
						fadd dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+4]
						jmp JMPR53 }
			      else53:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+4] }
			      JMPR53:   asm {   mov word ptr mp[MAYBE_EDI], ubx
						mov word ptr mp[MAYBE_EDI+2], 0
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_x3[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fcomp dword ptr video_x3[MAYBE_ESI]
						fstsw ax
						sahf
						jne if54
						jmp else54 }
			      if54:     asm {   fld dword ptr ubxf
						fsub dword ptr video_x3[MAYBE_ESI]
						fld dword ptr video_x3[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fsubr dword ptr video_x3[MAYBE_ESI]
						fdivp
						fld dword ptr video_y3[MAYBE_ESI]
						MOVZX_MAYBE_ESI, nvert
						fsub dword ptr video_y3[MAYBE_ESI]
						fmulp
						fadd dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+12]
						jmp JMPR52 }
			      else54:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+12] }
			      JMPR52:   asm {   mov word ptr mp[MAYBE_EDI+8], ubx
						mov word ptr mp[MAYBE_EDI+10], 0
						add MAYBE_EDI, 16
						jmp STOP5 }
			      else52:   asm {   MOVZX_MAYBE_ESI, pvert
						fld dword ptr video_x3[MAYBE_ESI]
						fcomp dword ptr ubxf
						fstsw ax
						sahf
						ja vnvert5
						mov ax, pvert
						mov vvert, ax
						jmp vpvert5 }
			      vnvert5:  asm {   mov ax, nvert
						mov vvert, ax }
			      vpvert5:  asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_x3[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fcomp dword ptr video_x3[MAYBE_ESI]
						fstsw ax
						sahf
						jne if55
						jmp else55 }
			      if55:     asm {   fld dword ptr ubxf
						fsub dword ptr video_x3[MAYBE_ESI]
						fld dword ptr video_x3[MAYBE_ESI]
						mov MAYBE_ESI, MAYBE_EBX
			      		
						fsubr dword ptr video_x3[MAYBE_ESI]
						fdivp
						fld dword ptr video_y3[MAYBE_ESI]
						MOVZX_MAYBE_ESI, vvert
						fsub dword ptr video_y3[MAYBE_ESI]
						fmulp
						fadd dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+4]
						jmp JMPR51 }
			      else55:   asm {
			      		mov MAYBE_ESI, MAYBE_EBX
			      		
						fld dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+4] }
			      JMPR51:   asm {   mov word ptr mp[MAYBE_EDI], ubx
						mov word ptr mp[MAYBE_EDI+2], 0
						add MAYBE_EDI, 8
						jmp STOP5 }
			      else51:   asm {   fld dword ptr video_x3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI]
						fld dword ptr video_y3[MAYBE_ESI]
						fistp dword ptr mp[MAYBE_EDI+4]
						add MAYBE_EDI, 8 }
			      STOP5:    asm {   inc vr
						mov ax, vr
						cmp ax, vr5
						jnb cutting_end_5
						jmp the_for_5 }

			 cutting_end_5: asm {   mov _8n, MAYBE_EDI
						sub _8n, 8
						shr MAYBE_EDI, 3
						mov vr6, di }

					if (vr6<3) {
						#ifdef WINDOWS
						asm popad
						#endif
						return;
					}

	/* Riempimento del poligono risultante. */

	// Tracciamento rapido (nr. 3 balletti & via, per i poligoni piccoli)

drawb:	
		#ifdef WINDOWS
		asm popad
		#endif
		
		if (!flares) {
			if (min_y==max_y) {
				if (min_x==max_x)
					adapted[min_x + riga[min_y]] = colore;
				else {
					ptr = max_x + riga[min_y];
					while (max_x>=min_x) {
						adapted[ptr] = colore;
						max_x--;
						ptr--;
					}
				}
				return;
			}
		}

	// Tracciamento complesso.

	// Disegna i bordi del poligono, con la funzione Segmento.

	asm {
		#ifdef WINDOWS
		pushad
		#endif
		xor MAYBE_ESI, MAYBE_ESI
	}
bordo:  asm {
		MOV_EAX_DWORD_PTR mp[MAYBE_ESI]
		MOV_DWORD_PTR xp, MAYBE_EAX
		MOV_EAX_DWORD_PTR mp[MAYBE_ESI+4]
		MOV_DWORD_PTR yp, MAYBE_EAX
		MOV_EAX_DWORD_PTR mp[MAYBE_ESI+8]
		MOV_DWORD_PTR xa, MAYBE_EAX
		MOV_EAX_DWORD_PTR mp[MAYBE_ESI+12]
		MOV_DWORD_PTR ya, MAYBE_EAX
		push MAYBE_ESI
		}
		Segmento ();
	asm {   pop MAYBE_ESI
		add MAYBE_ESI, 8
		cmp MAYBE_ESI, _8n
		jb bordo
		MOV_EAX_DWORD_PTR mp[MAYBE_ESI]
		MOV_DWORD_PTR xp, MAYBE_EAX
		MOV_EAX_DWORD_PTR mp[MAYBE_ESI+4]
		MOV_DWORD_PTR yp, MAYBE_EAX
		MOV_EAX_DWORD_PTR mp[0]
		MOV_DWORD_PTR xa, MAYBE_EAX
		MOV_EAX_DWORD_PTR mp[4]
		MOV_DWORD_PTR ya, MAYBE_EAX }
		Segmento ();
		#ifdef WINDOWS
		asm popad
		#endif
	// Pixel di Partenza.

	#ifdef WINDOWS
	Udword segmptr;
	#else
	Uword segmptr; //= riga[min_y] + min_x;
	#endif
	
	// Pixel d'Arrivo.

	#ifdef WINDOWS
	Udword lim_y; // = riga[max_y] + min_x;
	Udword lim_x; // = segmptr + max_x - min_x;
	Udword bytes; // = lim_x - segmptr + 2;
	Udword min_xDW = min_x;
	Udword max_xDW = max_x;
	Udword min_yDW = min_y;
	Udword max_yDW = max_y;
	#else
	Uword lim_y; // = riga[max_y] + min_x;
	Uword lim_x; // = segmptr + max_x - min_x;
	Uword bytes; // = lim_x - segmptr + 2;
	#endif
	
	asm {
		#ifdef WINDOWS
		pushad
		mov esi, min_yDW
		mov eax, min_xDW
		#else
		mov si, min_y
		mov ax, min_x
		#endif
		add MAYBE_ESI, MAYBE_ESI
		#ifdef WINDOWS
		mov edi, max_yDW
		add eax, dword ptr riga[esi*2]
		mov ebx, min_xDW
		#else
		mov di, max_y
		add ax, word ptr riga[si]
		mov bx, min_x
		#endif
		add MAYBE_EDI, MAYBE_EDI
		#ifdef WINDOWS
		mov segmptr, eax
		add ebx, dword ptr riga[edi*2]
		mov lim_y, ebx
		add eax, max_xDW
		sub eax, min_xDW
		mov lim_x, eax
		sub eax, segmptr
		add eax, 2			//REMOVE4: Maybe remove this line...
		mov bytes, eax
		popad
		#else
		mov segmptr, ax
		add bx, word ptr riga[di]
		mov lim_y, bx
		add ax, max_x
		sub ax, min_x
		mov lim_x, ax
		sub ax, segmptr
		add ax, 2
		mov bytes, ax
		#endif
		}

	// Riempimento (direction flag dev'essere 0)
	asm cld;

	switch (flares) {
		case 0:
			asm {
				#ifdef WINDOWS
				pushad
				mov edi, [adapted]
				#else
				pusha
				les di, dword ptr adapted
				#endif
				add lim_y, MAYBE_EDI
				add MAYBE_EDI, segmptr
				mov al, colore
				mov ah, colore
				SHL_EAX_16
				mov ah, colore }
		linea:  asm {   push MAYBE_EDI
				mov MAYBE_ECX, bytes
				mov al, 255
			  repne scasb
				jne pross
				mov MAYBE_ESI, MAYBE_EDI
			   repe scasb
				mov MAYBE_EBX, MAYBE_EDI
			  repne scasb
				jne fb1
			   repe scasb
				dec MAYBE_EDI
				dec MAYBE_ESI
				mov al, colore
				mov MAYBE_EDX, MAYBE_EDI
				sub MAYBE_EDX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI
				mov MAYBE_ECX, MAYBE_EDX
				shr MAYBE_ECX, 2
				jz no_store }
	store_stringdw: asm {
				#ifdef WINDOWS
				mov [edi], eax
				#else
				db 0x26, 0x66, 0x89, 0x05 // mov es:[di], eax
				#endif
				add MAYBE_EDI, 4
				dec MAYBE_ECX
				jnz store_stringdw }
	   no_store:    asm {   mov cl, dl
				and cl, 3
			    rep stosb
				jmp pross }
		fb1:    asm {   dec MAYBE_ESI
				dec MAYBE_EBX
				mov MAYBE_ECX, MAYBE_EBX
				mov al, colore
				sub MAYBE_ECX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI
			    rep stosb }
		pross:  asm {   pop MAYBE_EDI
				add MAYBE_EDI, 320
				cmp MAYBE_EDI, lim_y
				jbe linea
				#ifdef WINDOWS
				popad	
				#else
				popa
				#endif
				}
			break;
		case 1:
			asm {
				#ifdef WINDOWS
				pushad
				mov edi, [adapted]
				add lim_y, edi
				add edi, segmptr
				#else
				les di, dword ptr adapted
				add lim_y, di
				add di, segmptr
				#endif
				mov al, colore
				and al, 0x3F
				mov colore, al }
		l2:     asm {
				push MAYBE_EDI
				mov MAYBE_ECX, bytes
				mov al, 255
			  repne scasb
				jne pross2
				mov MAYBE_ESI, MAYBE_EDI
			   repe scasb
				mov MAYBE_EBX, MAYBE_EDI
			  repne scasb
				jne fb2
			   repe scasb
				dec MAYBE_EDI
				dec MAYBE_ESI
				mov MAYBE_ECX, MAYBE_EDI
				sub MAYBE_ECX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI }
		fill2:  asm {
				#ifdef WINDOWS
				mov al, [edi-1]
				#else
				mov al, es:[di-1]
				#endif
				and al, 0x3F
				add al, colore
				cmp al, 62
				jb flow
				mov al, 62 }
		flow:   asm {
				#ifdef WINDOWS
				mov [edi], al
				#else
				mov es:[di], al
				#endif
				inc MAYBE_EDI
				dec MAYBE_ECX
				jnz fill2
				jmp pross2 }
		fb2:    asm {   dec MAYBE_ESI
				dec MAYBE_EBX
				mov MAYBE_ECX, MAYBE_EBX
				sub MAYBE_ECX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI
				mov dl, colore
				shr dl, 1 }
		fb2a:   asm {
				#ifdef WINDOWS
				mov al, [edi-1]
				#else
				mov al, es:[di-1]
				#endif
				and al, 0x3F
				add al, dl
				cmp al, 62
				jb flow4
				mov al, 62 }
		flow4:  asm {
				#ifdef WINDOWS
				mov [edi], al
				#else
				mov es:[di], al
				#endif
				inc MAYBE_EDI
				dec MAYBE_ECX
				jnz fb2a }
		pross2: asm {
				pop MAYBE_EDI
				add MAYBE_EDI, 320
				cmp MAYBE_EDI, lim_y
				jbe l2
				#ifdef WINDOWS
				popad
				#endif
			}
			break;
		case 2:
			asm {
				#ifdef WINDOWS
				pushad
				mov eax, [adapted]
				mov edi, [adapted]
				#else
				push ds
				les ax, dword ptr adapted
				lds di, dword ptr adapted
				#endif
				add lim_y, MAYBE_EDI
				add MAYBE_EDI, segmptr }
		l3:	asm {	mov al, 0xFF
				push MAYBE_EDI
				mov MAYBE_ECX, bytes
			  repne scasb
				jne pross3
				mov MAYBE_ESI, MAYBE_EDI
			   repe scasb
				mov MAYBE_EBX, MAYBE_EDI
			  repne scasb
				jne fb3
			   repe scasb
				dec MAYBE_EDI
				dec MAYBE_ESI
				mov MAYBE_ECX, MAYBE_EDI
				sub MAYBE_ECX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI }
		fill3:  asm {   cmp byte ptr [MAYBE_EDI], 0xFF
				jne tsnob
				xor MAYBE_EAX, MAYBE_EAX
				mov ah, [MAYBE_EDI-321]
				and ah, 0x3F
				or ah, 0x40
				mov [MAYBE_EDI], ah
				jmp under }
		tsnob:  asm {   mov al, [MAYBE_EDI]
				and ax, 0x3F
				or  al, 0x40
				add MAYBE_EAX, MAYBE_ECX
				cmp MAYBE_EAX, 128
				jb dnorm
				mov al, 127 }
		dnorm:  asm	mov [MAYBE_EDI], al
		under:  asm {   inc MAYBE_EDI
				dec MAYBE_ECX
				jnz fill3
				jmp pross3 }
		fb3:    asm {   dec MAYBE_ESI
				dec MAYBE_EBX
				mov MAYBE_ECX, MAYBE_EBX
				sub MAYBE_ECX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI }
		fb3a:   asm {   mov ah, [MAYBE_EDI-321]
				cmp ah, 0xFF
				jne tsnoby
				mov ah, [MAYBE_EDI-642] }
		tsnoby: asm {   and ah, 0x3F
				or ah, 0x40
				mov [MAYBE_EDI], ah
				inc MAYBE_EDI
				dec MAYBE_ECX
				jnz fb3a }
		pross3: asm {   pop MAYBE_EDI
				add MAYBE_EDI, 320
				cmp MAYBE_EDI, lim_y
				ja l3end
				jmp l3 }
		l3end:	
				#ifdef WINDOWS
				asm popad
				#else
				asm	pop ds
				#endif
			break;
		// effetto flares = 3 spostato a "polymap"
		case 4:
			asm {
				#ifdef WINDOWS
				pushad
				mov edi, [adapted]
				#else
				pusha
				les di, dword ptr adapted
				#endif
				add lim_y, MAYBE_EDI
				add MAYBE_EDI, segmptr }
		 fil4a: asm {	mov al, colore
				mov ah, colore
				SHL_EAX_16
				mov ah, colore
				push MAYBE_EDI
				mov MAYBE_ECX, bytes
				mov al, 255
			  repne scasb
				jne fil4d
				mov MAYBE_ESI, MAYBE_EDI
			   repe scasb
				mov MAYBE_EBX, MAYBE_EDI
			  repne scasb
				jne fil4e
			   repe scasb
				dec MAYBE_EDI
				dec MAYBE_ESI
				mov al, colore
				mov MAYBE_EDX, MAYBE_EDI
				sub MAYBE_EDX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI
				mov MAYBE_ECX, MAYBE_EDX
				shr MAYBE_ECX, 2
				jz fil4c }
		 fil4b: asm {
		 		#ifdef WINDOWS
		 		mov [edi], eax
		 		#else
		 		db 0x26, 0x66, 0x89, 0x05 // mov es:[di], eax
		 		#endif
				add MAYBE_EDI, 4	//REMOVE4: Maybe?
				dec MAYBE_ECX
				jnz fil4b }
		 fil4c: asm {   mov cl, dl
				and cl, 3
			    rep stosb
				jmp fil4d }
		 fil4e: asm {   dec MAYBE_ESI
				dec MAYBE_EBX
				mov MAYBE_ECX, MAYBE_EBX
				mov al, colore
				sub MAYBE_ECX, MAYBE_ESI
				mov MAYBE_EDI, MAYBE_ESI
			    rep stosb }
		 fil4d: asm {   mov al, colore
				mov ah, colore
				and al, 0x3F
				and ah, 0xC0
				add al, ent
				cmp al, 0x3F
				jbe fil4f
				mov al, 0x3F
				test ent, 0x80
				jz  fil4f
				xor al, al }
		 fil4f: asm {   or  al, ah
				mov colore, al
				pop MAYBE_EDI
				add MAYBE_EDI, 320
				cmp MAYBE_EDI, lim_y
				jbe fil4a
				#ifdef WINDOWS
			 	popad
			 	#else
			 	popa
			 	#endif
			 	}
	}
}
