/*

	Noctis galactic guide / SET command.
	GOES Net Module.

	Modified Apr 22 2005 by SL: Updated for starmap3.
		Also added a feature: If you feed it the name of a planet in another system, it will give the name of the system it's in.
	Modified Feb 13 2005 by SL to fix possible bug due to use of align_m and align_e, now uses start_y and start_z instead.
	
*/

const double MAX_OBJECTS_PER_STAR = 80;

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <dos.h>
#include <io.h>
#include "modshare.hpp"

//////////////////////////////////////////////////////////////////////////////

//char   *situation_file  = "..\\DATA\\Current.BIN";

char   sync               = 1;		// 0
char   anti_rad           = 1;          // 1
char   pl_search          = 0;          // 2
char   field_amplificator = 0;          // 3
char   ilight             = 63;         // 4
char   ilightv            = 1;          // 5
char   charge             = 3;          // 6
char   revcontrols        = 0;          // 7
char   ap_targetting      = 0;          // 8
char   ap_targetted       = 0;          // 9
char   ip_targetting      = 0;          // 10
char   ip_targetted       = -1;		// 11
char   ip_reaching        = 0;          // 12
char   ip_reached         = 0;          // 13
char   ap_target_spin     = 0;          // 14
char   ap_target_r        = 0;          // 15
char   ap_target_g        = 0;          // 16
char   ap_target_b        = 0;          // 17
char   nearstar_spin      = 0;          // 18
char   nearstar_r         = 0;          // 19
char   nearstar_g         = 0;          // 20
char   nearstar_b         = 0;          // 21
char   gburst	          = 0;          // 22
char   menusalwayson      = 1;		// 23
char   depolarize  	  = 0;          // 24
int    sys                = 4;		// 25
int    pwr                = 15000;	// 27
int    dev_page           = 0;		// 29
int    ap_target_class    = 0;		// 31
int    f_ray_elapsed	  = 0;		// 33
int    nearstar_class     = 0;		// 35
int    nearstar_nop       = 0;		// 37
float  pos_x              = 0;		// 39
float  pos_y              = 0;		// 43
float  pos_z              = -500;	// 47
float  user_alfa          = 0;		// 51
float  user_beta          = 0;		// 55
float  navigation_beta    = 0;		// 59
float  ap_target_ray      = 0;		// 63
float  nearstar_ray       = 1000;	// 67
double dzat_x             = +3797120;
double dzat_y             = -4352112;
double dzat_z             = -925018;
double ap_target_x        = 0;
double ap_target_y        = 1E9;
double ap_target_z        = 0;
double nearstar_x         = 0;
double nearstar_y         = 1E9;
double nearstar_z         = 0;
double helptime           = 0;
double ip_target_initial_d= 0;
double requested_approach_coefficient = 1;
double current_approach_coefficient = 1;
double reaction_time      = 0.01;
char   fcs_status[11]     = "STANDBY";
int    fcs_status_delay   = 0;
int    psys               = 4;
double ap_target_initial_d= 0;
double requested_vimana_coefficient = 1;
double current_vimana_coefficient = 1;
double vimana_reaction_time = 0.01;
char   lithium_collector  = 0;
char   autoscreenoff	  = 0;
char   ap_reached         = 0;
int    lifter		  = 0;
double secs		  = 0;

void unfreeze ()
{
	FILE * fh = fopen (real_situation_file, "rb");
	if (fh!=NULL) {
		fread (&sync, 244, 1, fh);
		fclose (fh);
	}
}

//////////////////////////////////////////////////////////////////////////////

double 	object_id = 12345;
char   	object_label[25];
double 	s_object_id = 12345;
char   	s_object_label[25];

double	subject_id = 12345;
double  idscale = 0.00001;

int	sts;
char	query;

long	round;
int 	i;
FILE * fh, gh;
int 	analyzed_sectors_range;
char	*file = "..\\DATA\\starmap3.map";
char    *comm = "..\\DATA\\COMM.BIN";

char	outbuffer[40];
char	textbuffer[40];
char	parbuffer[160];
char	nullbuffer[128];
char	objectname[21];
char	subjectname[21];
char	starname[21];

Dword nearstar_sx	  	= 0x7fffffff;		//53
Dword nearstar_sy	  	= 0x7fffffff;		//57
Dword nearstar_sz	  	= 0x7fffffff;		//61
Uword obj_pNum;
Uword obj_mNum;
#define new_data_start 245+5+120

Uchar flags;
Udword discoverer;
char name[21];
char lastname[21];
Dword sx, sy, sz;
Uword data;
Udword nextAlternateFP;
Udword starFP;
Bool exactMatch = 0;

char find (char *tgtname, Udword starmap3Len)
{
	Word p, n, ctc, found;
	ctc = strlen (tgtname);
	if (ctc > 20 || ctc <= 0) {
		msg ("INVALID OBJECT NAME.");
		return(0);
	}
	n = 0;
	found = 0;
	exactMatch=0;
	fseek (fh, 10, SEEK_SET);
	while (ftell(fh)<starmap3Len) {
		fread(&flags, 1, 1, fh);
		fread(&discoverer, 4, 1, fh);
		fread(&name, 20, 1, fh);
		if (flags&0x8) {
			fread(&sx, 4, 1, fh);
			fread(&sy, 4, 1, fh);
			fread(&sz, 4, 1, fh);
			fread(&data, 2, 1, fh);
			fread(&nextAlternateFP, 4, 1, fh);
			if (memcmp(name, tgtname, ctc)==0 && !(flags&0x20)) {
				if (ctc<20 && ctc>=2 && name[ctc]==32 && name[ctc-1]!=32) {
					exactMatch=2;
					if (n>0) {
						msg("NEVERMIND, FOUND EXACT MATCH");
						msg(name);
						n=1;
					}
				}
				if (!exactMatch) {
					//found it
					if (n==1) {	//If this is the second match
						msg ("AMBIGUOUS SEARCH KEY:");
						msg ("PLEASE EXPAND NAME...");
						msg (divider);
						msg ("POSSIBLE RESULTS ARE:");
						msg (divider);
						lastname[20]=0;
						msg (object_label);
					}
					if (n>0) {
						msg (name);
					}
					n++;
				}
				if (exactMatch!=1) {
					memcpy(object_label, name, 20);
					memcpy(subjectname, object_label, 20);
					memcpy(starname, subjectname, 20);
					//printf("FOUND. SX=%li SY=%li SZ=%li. ", sx, sy, sz);
					nearstar_sx = sx;
					nearstar_sy = sy;
					nearstar_sz = sz;
					//printf("FOUND. NSX=%li NSY=%li NSZ=%li. ", nearstar_sx, nearstar_sy, nearstar_sz);
					obj_pNum=0x1F;
					obj_mNum=0x1F;
					found=1;
					/*while (p >= 0) {
						if (name[p] != 32) {
							if (name[p] == tgtname[p])
								return (found);
							else
								break;
						}
						p--;
					}*/
					if (exactMatch==2) return found;
				}
			}
		} else {
			fread(&starFP, 4, 1, fh);
			fread(&data, 2, 1, fh);
			fread(&nextAlternateFP, 4, 1, fh);
			if (memcmp(name, tgtname, ctc)==0 && !(flags&0x20)) {
				if (ctc<20 && ctc>=2 && name[ctc]==32 && name[ctc-1]!=32) {
					exactMatch=2;
					if (n>0) {
						msg("NEVERMIND, FOUND EXACT MATCH");
						msg(name);
						n=1;
					}
				}
				if (!exactMatch) {
					//found it
					if (n==1) {	//If this is the second match
						msg ("AMBIGUOUS SEARCH KEY:");
						msg ("PLEASE EXPAND NAME...");
						msg (divider);
						msg ("POSSIBLE RESULTS ARE:");
						msg (divider);
						lastname[20]=0;
						msg (object_label);
					}
					if (n>0) {
						msg (name);
					}
					n++;
				}
				if (exactMatch!=1) {
					memcpy(object_label, name, 20);
					memcpy(subjectname, object_label, 20);
					
					Dword pos = ftell(fh);
					fseek(fh, starFP+5, SEEK_SET);
					fread(starname, 20, 1, fh);
					fseek(fh, starFP+25, SEEK_SET);
					fread(&nearstar_sx, 4, 1, fh);
					fread(&nearstar_sy, 4, 1, fh);
					fread(&nearstar_sz, 4, 1, fh);
					fseek(fh, pos, SEEK_SET);
					
					obj_pNum = ((data>>4)&0x1F);
					obj_mNum = ((data>>9)&0x1F);
					found=2;
					/*while (p >= 0) {
						if (name[p] != 32) {
							if (name[p] == tgtname[p])
								return (found);
							else
								break;
						}
						p--;
					}*/
					if (exactMatch==2) return found;
				}
			}
		}
	}
	
	if (!n)
		msg ("OBJECT NOT FOUND.");
	if (n > 1) {
		found=0;
	}
	return (found);
}

/*
char find (char *starname)
{
	int p, n, ctc, found;
	ctc = strlen (starname);
	if (ctc > 20 || ctc <= 0) {
		msg ("INVALID OBJECT NAME.");
		return(0);
	}
	n = 0;
	found = 0;
	lseek (fh, 4, SEEK_SET);
	while (_read (fh, &s_object_id, 8) && _read (fh, &s_object_label, 24) == 24) {
		if (memcmp (&s_object_id, "Removed:", 8)) {
			if (!memcmp (s_object_label, starname, ctc)) {
				n++;
				memcpy (object_label, s_object_label, 24);
				object_id = s_object_id;
				memcpy (subjectname, object_label, 20);
				subject_id = object_id;
				if (object_label[21] == 'S') found = 1;
				if (object_label[21] == 'P') found = 2;
				p = 20;
				while (p >= 0) {
					if (s_object_label[p] != 32) {
						if (s_object_label[p] == starname[p])
							return (found);
						else
							break;
					}
					p--;
				}
			}
		}
	}
	if (!n)
		msg ("OBJECT NOT FOUND.");
	if (n > 1) {
		msg ("AMBIGUOUS SEARCH KEY:");
		msg ("PLEASE EXPAND NAME...");
		msg (divider);
		msg ("POSSIBLE RESULTS ARE:");
		msg (divider);
		lseek (fh, 4, SEEK_SET);
		while (_read (fh, &s_object_id, 8) && _read (fh, &s_object_label, 24) == 24) {
		if (memcmp (&s_object_id, "Removed:", 8) && !memcmp (s_object_label, starname, ctc)) {
			s_object_label[21] = 0;
			msg (s_object_label);
		}}
		msg (divider);
		found = 0;
	}
	return (found);
}*/

//////////////////////////////////////////////////////////////////////////////

const double deg = M_PI / 180;

#define qt_M_PI   4*M_PI/3

#define star_classes    12
#define planet_types    10
#define avgmoons        4
#define log2avgmoons	2
#define maxbodies	20 * avgmoons

char class_rgb[3*star_classes] = {
	63, 58, 40,
	30, 50, 63,
	63, 63, 63,
	63, 30, 20,
	63, 55, 32,
	32, 16, 10,
	32, 28, 24,
	10, 20, 63,
	63, 32, 16,
	48, 32, 63,
	40, 10, 10,
	00, 63, 63
};

int class_ray[star_classes] = { 5000, 15000, 300, 20000, 15000, 1000, 3000,
				2000, 4000, 1500, 30000, 250 };

int class_rayvar[star_classes] = { 2000, 10000, 200, 15000, 5000, 1000, 3000,
				   500, 5000, 10000, 1000, 10 };

int class_act[star_classes] = { 2, 4, 1, 6, 5, 10, 100, 1, 2, 1, 10, 1 };

char class_planets[star_classes] = { 12, 18, 8, 15, 20, 3, 0, 1, 7, 20, 2, 5 };

char   nearstar_p_type       [maxbodies];
int    nearstar_p_owner	     [maxbodies];
char   nearstar_p_moonid     [maxbodies];
double nearstar_p_ring       [maxbodies];
double nearstar_p_tilt       [maxbodies];
double nearstar_p_ray        [maxbodies];
double nearstar_p_orb_ray    [maxbodies];
double nearstar_p_orb_seed   [maxbodies];
double nearstar_p_orb_tilt   [maxbodies];
double nearstar_p_orb_orient [maxbodies];
double nearstar_p_orb_ecc    [maxbodies];

int planet_possiblemoons[] = { 1, 1, 2, 3, 2, 2, 18, 2, 3, 20, 20 };

const double planet_orb_scaling=  5.0;
const double avg_planet_sizing =  2.4;
const double moon_orb_scaling  = 12.8;
const double avg_moon_sizing   =  1.8;

double avg_planet_ray[] = { 0.007, 0.003, 0.010, 0.011, 0.010,
			    0.008, 0.064, 0.009, 0.012, 0.125,
			    2.000 };

double laststar_x, laststar_y, laststar_z;
float  zrandom (int range) { return (random(range) - random(range)); }
double nearstar_identity;
int    nearstar_nob;

/*
char isthere (double star_id)
{
	char warnbuffer[41];

	double laststar_id;

	double sidlow = star_id - idscale;
	double sidhigh = star_id + idscale;

	unsigned sx, sy, sz;

	unsigned visible_sectors_x = analyzed_sectors_range;
	unsigned visible_sectors_y = analyzed_sectors_range;
	unsigned visible_sectors_z = analyzed_sectors_range;

	long   	sect_x, sect_y, sect_z;

	sect_x = (dzat_x - visible_sectors_x*50000) / 100000; sect_x *= 100000;
	sect_y = (dzat_y - visible_sectors_y*50000) / 100000; sect_y *= 100000;
	sect_z = (dzat_z - visible_sectors_z*50000) / 100000; sect_z *= 100000;

	long start_y = sect_y;
	long start_z = sect_z;
	
	asm {	mov ax, visible_sectors_x
		mov sx, ax }
e_while:asm {	mov ax, visible_sectors_y
		mov sy, ax }
m_while:asm {	mov ax, visible_sectors_z
		mov sz, ax }
i_while:asm {	db 0x66, 0xBB, 0x50, 0xC3, 0x00, 0x00 // mov ebx, 50000
		db 0x66; mov ax, word ptr sect_x
		db 0x66; mov dx, word ptr sect_z
		db 0x66; add ax, dx
		db 0x66; mov cx, ax
		db 0x66; mov dx, ax
		db 0x66, 0x81, 0xE2, 0xFF, 0xFF, 0x01, 0x00 // and edx, 0x0001FFFF
		db 0x66; add dx, word ptr sect_x
		db 0x66; sub dx, bx
		db 0x66; mov word ptr laststar_x, dx
		db 0x66; imul dx
		db 0x66; add dx, ax
		db 0x66; add cx, dx
		db 0x66, 0x81, 0xE2, 0xFF, 0xFF, 0x01, 0x00 // and edx, 0x0001FFFF
		db 0x66; add dx, word ptr sect_y
		db 0x66; sub dx, bx
		db 0x66; mov word ptr laststar_y, dx
		db 0x66; mov ax, cx
		db 0x66; imul dx
		db 0x66; add dx, ax
		db 0x66, 0x81, 0xE2, 0xFF, 0xFF, 0x01, 0x00 // and edx, 0x0001FFFF
		db 0x66; add dx, word ptr sect_z
		db 0x66; sub dx, bx
		db 0x66; mov word ptr laststar_z, dx
		fild dword ptr laststar_x
		fst  laststar_x
		fmul idscale
		fild dword ptr laststar_y
		fst  laststar_y
		fmul idscale
		fild dword ptr laststar_z
		fst  laststar_z
		fmul idscale
		fmulp
		fmulp
		fst laststar_id
		fcomp sidlow
		fstsw ax
		sahf
		jb i_next
		fld laststar_id
		fcomp sidhigh
		fstsw ax
		sahf
		jb y_end }
i_next:	asm {	db 0x66; mov ax, word ptr advance
		db 0x66; add word ptr sect_z, ax
		dec sz
		jz i_end
		jmp i_while }
i_end:	  asm { db 0x66; mov dx, word ptr start_z
		db 0x66; mov word ptr sect_z, dx
		db 0x66; add word ptr sect_y, ax
		dec sy
		jz m_end
		jmp m_while }
m_end:	  asm { db 0x66; mov dx, word ptr start_y
		db 0x66; mov word ptr sect_y, dx
		db 0x66; add word ptr sect_x, ax
		dec sx
		jz e_end
		db 0x66; pusha }
		if (sts > 100) {
			sprintf (warnbuffer, "SLICE %d OF %d", visible_sectors_x - sx, visible_sectors_x);
			warnMsg (warnbuffer, 0);
			while (kbhit()) {
				if (getch() == 27) {
					asm { db 0x66; popa }
					return (0);
				}
			}
		}
	  asm { db 0x66; popa
		jmp e_while }
e_end:	  return (0);
y_end:	  return (1);
}
*/

void extract_ap_target_infos ()
{
	srand (ap_target_x/100000*ap_target_y/100000*ap_target_z/100000);

	ap_target_class = random (star_classes);
	ap_target_ray = ((float)class_ray[ap_target_class] + (float)random(class_rayvar[ap_target_class])) * 0.001;

	ap_target_r = class_rgb[3*ap_target_class+0];
	ap_target_g = class_rgb[3*ap_target_class+1];
	ap_target_b = class_rgb[3*ap_target_class+2];

	ap_target_spin = 0;
	if (ap_target_class==11) ap_target_spin = random (30) + 1;
	if (ap_target_class==7) ap_target_spin = random (12) + 1;
	if (ap_target_class==2) ap_target_spin = random (4) + 1;
}

void prepare_nearstar ()
{
	int    n, c, q, r, s, t;
	double key_radius;

	nearstar_class = ap_target_class;
	nearstar_x = ap_target_x;
	nearstar_y = ap_target_y;
	nearstar_z = ap_target_z;
	nearstar_ray = ap_target_ray;
	nearstar_spin = ap_target_spin;
	nearstar_r = ap_target_r;
	nearstar_g = ap_target_g;
	nearstar_b = ap_target_b;

	nearstar_identity = nearstar_x/100000*nearstar_y/100000*nearstar_z/100000;

	srand ((long)nearstar_x%10000*(long)nearstar_y%10000*(long)nearstar_z%10000);

	nearstar_nop = random (class_planets[nearstar_class] + 1);

	for (n=0; n<nearstar_nop; n++) {
		nearstar_p_owner[n]	 = -1;
		nearstar_p_orb_orient[n] = (double) deg * (double) random (360);
		nearstar_p_orb_seed[n]   = 3 * (n*n+1) * nearstar_ray + (float) random (300 * nearstar_ray) / 100;
		nearstar_p_tilt[n]       = zrandom (10*nearstar_p_orb_seed[n]) / 500;
		nearstar_p_orb_tilt[n]   = zrandom (10*nearstar_p_orb_seed[n]) / 5000;
		nearstar_p_orb_ecc[n]    = 1 - (double) random (nearstar_p_orb_seed[n] + 10*fabs(nearstar_p_orb_tilt[n])) / 2000;
		nearstar_p_ray[n]        = (double) random (nearstar_p_orb_seed[n]) * 0.001 + 0.01;
		nearstar_p_ring[n]	 = zrandom (nearstar_p_ray[n]) * (1 + (double) random (1000) / 100);
		if (nearstar_class != 8)
			nearstar_p_type[n] = random (planet_types);
		else {
			if (random(2)) {
				nearstar_p_type[n] = 10;
				nearstar_p_orb_tilt[n] *= 100;
			}
			else
				nearstar_p_type[n] = random (planet_types);
		}
		if (nearstar_class==2||nearstar_class==7||nearstar_class==15)
			nearstar_p_orb_seed[n] *= 10;
	}

	if (!nearstar_class) {
		if (random(4)==2) nearstar_p_type[2] = 3;
		if (random(4)==2) nearstar_p_type[3] = 3;
		if (random(4)==2) nearstar_p_type[4] = 3;
	}

	for (n=0; n<nearstar_nop; n++) {
		switch (nearstar_class) {
			case 2: while (nearstar_p_type[n]==3)
					nearstar_p_type[n] = random (10);
				break;
			case 5: while (nearstar_p_type[n]==6||
				       nearstar_p_type[n]==9)
					nearstar_p_type[n] = random (10);
				break;
			case 7:	nearstar_p_type[n] = 9;
				break;
			case 9: while (nearstar_p_type[n]!=0&&
				       nearstar_p_type[n]!=6&&
				       nearstar_p_type[n]!=9)
					nearstar_p_type[n] = random (10);
				break;
			case 11:while (nearstar_p_type[n]!=1&&
				       nearstar_p_type[n]!=7)
					nearstar_p_type[n] = random (10);
		}
	}

	for (n=0; n<nearstar_nop; n++) {
		switch (nearstar_p_type[n]) {
			case 0:
				if (random(8))
					nearstar_p_type[n] ++;
				break;
			case 3:
				if ((n<2)||(n>6)||(nearstar_class&&random(4))) {
					if (random(2))
						nearstar_p_type[n]++;
					else
						nearstar_p_type[n]--;
				}
				break;
			case 7:
				if (n<7) {
					if (random(2))
						nearstar_p_type[n] --;
					else
						nearstar_p_type[n] -= 2;
				}
				break;
		}
	}

	nearstar_nob = nearstar_nop;

	if (nearstar_class==2||nearstar_class==7||nearstar_class==15)
		goto no_moons;

	for (n=0; n<nearstar_nop; n++) {
		// (t=) Numero di satelliti per pianeta.
		s = nearstar_p_type[n];
		if (n < 2) {
			t = 0;
			if (s == 10)
				t = random (3);
		}
		else
			t = random (planet_possiblemoons[s] + 1);
		if (nearstar_nob + t > maxbodies)
			t = maxbodies - nearstar_nob;
		for (c=0; c<t; c++) {
			q 			 = nearstar_nob + c;
			nearstar_p_owner[q]	 = n;
			nearstar_p_moonid[q]	 = c;
			nearstar_p_orb_orient[q] = (double) deg * (double) random (360);
			nearstar_p_orb_seed[q]   = (c*c+4) * nearstar_p_ray[n] + (float) zrandom (300 * nearstar_p_ray[n]) / 100;
			nearstar_p_tilt[q]       = zrandom (10*nearstar_p_orb_seed[q]) / 50;
			nearstar_p_orb_tilt[q]   = zrandom (10*nearstar_p_orb_seed[q]) / 500;
			nearstar_p_orb_ecc[q]    = 1 - (double) random (nearstar_p_orb_seed[q] + 10*fabs(nearstar_p_orb_tilt[q])) / 2000;
			nearstar_p_ray[q]        = (double) random (nearstar_p_orb_seed[n]) * 0.05 + 0.1;
			nearstar_p_ring[q]	 = 0;
			nearstar_p_type[q]       = random (planet_types);
			r = nearstar_p_type[q];
			if (r==9 && s != 10) r = 2;
			if (r==6 && s < 9) r = 5;
			if (n > 7 && random(c)) r = 7;
			if (n > 9 && random(c)) r = 7;
			if (r==2 || r==3 || r==4 || r==8) {
				if (s != 6 && s < 9)
					r = 1;
			}
			if (r==3 && s < 9) {
				if (n > 7)
					r = 7;
				if (nearstar_class && random(4))
					r = 5;
				if (nearstar_class == 2 ||
				    nearstar_class == 7 ||
				    nearstar_class == 11)
					r = 8;
			}
			if (r==7 && n <= 5) r = 1;
			if ((nearstar_class==2||nearstar_class==5||
			     nearstar_class==7||nearstar_class==11)
			     && random(n)) r = 7;
			nearstar_p_type[q] = r;
		}
		nearstar_nob += t;
	}

no_moons:
	key_radius = nearstar_ray * planet_orb_scaling;
	if (nearstar_class == 8) key_radius *= 2;
	if (nearstar_class == 2) key_radius *= 16;
	if (nearstar_class == 7) key_radius *= 18;
	if (nearstar_class == 11) key_radius *= 20;
	for (n=0; n<nearstar_nop; n++) {
		nearstar_p_ray[n] = avg_planet_ray[nearstar_p_type[n]]
				  + avg_planet_ray[nearstar_p_type[n]] * zrandom (100) / 200;
		nearstar_p_ray[n] *= avg_planet_sizing;
		nearstar_p_orb_ray[n] = key_radius + key_radius * zrandom (100) / 500;
		nearstar_p_orb_ray[n] += key_radius * avg_planet_ray[nearstar_p_type[n]];
		if (n < 8)
			key_radius += nearstar_p_orb_ray[n];
		else
			key_radius += 0.22 * nearstar_p_orb_ray[n];
	}

	n = nearstar_nop;
	while (n < nearstar_nob) {
		q = 0;
		c = nearstar_p_owner[n];
		key_radius = nearstar_p_ray[c] * moon_orb_scaling;
		while (n<nearstar_nob && nearstar_p_owner[n] == c) {
			nearstar_p_ray[n] = avg_planet_ray[nearstar_p_type[n]]
					  + avg_planet_ray[nearstar_p_type[n]] * zrandom (100) / 200;
			nearstar_p_ray[n] *= avg_moon_sizing;
			nearstar_p_orb_ray[n] = key_radius + key_radius * zrandom (100) / 250;
			nearstar_p_orb_ray[n] += key_radius * avg_planet_ray[nearstar_p_type[n]];
			if (q < 2) key_radius += nearstar_p_orb_ray[n];
			if (q >= 2 && q < 8) key_radius += 0.12 * nearstar_p_orb_ray[n];
			if (q >= 8) key_radius += 0.025 * nearstar_p_orb_ray[n];
			q++;
			n++;
		}
	}

	for (n = 0; n < nearstar_nop; n++) {
		nearstar_p_ring[n] = 0.75 * nearstar_p_ray[n] * (2 + random(3));
		s = nearstar_p_type[n];
		if (s != 6 && s != 9) {
			if (random(5))
				nearstar_p_ring[n] = 0;
		}
		else {
			if (random(2))
				nearstar_p_ring[n] = 0;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////

long fpart (double id, char *label)
{
	long	fpart, no;
	int	attempts = 0;
	double	multiplier = 1E9;

	if (label[21] == 'P') {
		no  = label[23] - '0';
		no += 10 * (label[22] - '0');
		id -= no;
	}

	id = fabs(id);

	do {
		fpart = multiplier * ((double)id - (long)id);
		multiplier *= 1000;
		attempts++;
	} while (fpart < 1E6 && attempts < 44);

	return (fpart);
}

Uchar Nearstar_BodyNumber(Uchar pN, Uchar mN) {
	Uchar retval = 0;
	if (mN==0x1F) {
		retval = pN;
	} else {
		for (Uchar body = nearstar_nop; body<nearstar_nob; body++) {
			if (nearstar_p_owner[body]==pN && nearstar_p_moonid[body]==mN) {
				retval=body;
				break;
			}
		}
	}
	return retval;
}

void settarget ()
{
	int	ch;
	int	planet_nr;
	double 	star_id;
	long	fp_star_check;
	long	fp_object_check;
	
	/*if (query == 2) {
		planet_nr  = object_label[23] - '0';
		planet_nr += 10 * (object_label[22] - '0');
		star_id    = object_id - planet_nr;
	}
	else
		star_id = object_id;
	*/
	char buff[120];
	//sprintf(buff, "STARID=%f", star_id); msg(buff);
	
	/*if (!isthere2 (star_id, analyzed_sectors_range, dzat_x ,dzat_y, dzat_z, sts>100)) {
		msg (subjectname);
		msg ("IS OUT OF RANGE");
		return;
	}
	else {
		laststar_x = foundstar_x; laststar_y = foundstar_y; laststar_z = foundstar_z;
		fp_star_check = fpart (star_id, "F-PARTTESTSTARLABEL Sxx");
	}*/
	//printf( "O X=%f Y=%f Z=%f. ", nearstar_x, nearstar_y, nearstar_z);
	
	double original_star_x = nearstar_x;
	double original_star_y = nearstar_y;
	double original_star_z = nearstar_z;
	//printf("F %.20s. ", sm3data.starname);
	//printf("BZZT: SX=%lli SY=%lli SZ=%lli. ", sm3data.sx, sm3data.sy, sm3data.sz);
	PrepareFromSectorCoords(sm3data.sx, sm3data.sy, sm3data.sz);
	//printf( "F X=%f Y=%f Z=%f. ", foundstar_x, foundstar_y, foundstar_z);
	if (sm3data.retvalType==RETVAL_STAR) {	//system target
		
		FILE * ch = fopen (comm, "wb");
		if (ch != NULL) {
			//double dnsx = foundstar_x;
			//double dnsy = foundstar_y;
			//double dnsz = foundstar_z;
			fwrite (&foundstar_x, 8, 1, ch);
			fwrite (&foundstar_y, 8, 1, ch);
			fwrite (&foundstar_z, 8, 1, ch);
			fclose (ch);
			msg ("REM. TARGET DATA SENT");
			msg ("STARTING VIMANA DRIVE");
		}
		else
			msg ("COMMUNICATION ERROR.");
	} else if (sm3data.retvalType==RETVAL_PLANET) {	//planet target
		//Make sure it's the same system?
		if (original_star_x == foundstar_x && original_star_y == foundstar_y && original_star_z == foundstar_z) {
			ap_target_x = foundstar_x;
			ap_target_y = foundstar_y;
			ap_target_z = foundstar_z;
			extract_ap_target_infos ();
			prepare_nearstar ();
			planet_nr = Nearstar_BodyNumber(sm3data.pNum, sm3data.mNum)+1;
			//printf("PN=%i MN=%i BN=%i.", obj_pNum, obj_mNum, planet_nr);
			FILE * ch = fopen (comm, "wb");
			if (ch != NULL) {
				fwrite (&planet_nr, 2, 1, ch);
				fclose (ch);
				msg ("LOC. TARGET DATA SENT");
				msg ("BEGIN IN-SYSTEM DRIVE");
			} else {
				msg ("COMMUNICATION ERROR.");
			}
		} else {
			sprintf (buff, "%.20s", sm3data.starname);
			int i = strlen(buff)-1;
			while (buff[i]==32) {
				buff[i]=0;
				i--;
			}
			sprintf (textbuffer, "PLANET FOUND IN THE  '%s' SYSTEM", buff);
			longmsg(textbuffer);
			msg ("YOU CAN USE 'ST'");
			msg ("TO GO THERE.");
		}
		//old code
		/*sprintf(buff, "LSX=%f", laststar_x); msg(buff);
		sprintf(buff, "LSY=%f", laststar_y); msg(buff);
		sprintf(buff, "LSZ=%f", laststar_z); msg(buff);
		sprintf(buff, "NSX=%f", nearstar_x); msg(buff);
		sprintf(buff, "NSY=%f", nearstar_y); msg(buff);
		sprintf(buff, "NSZ=%f", nearstar_z); msg(buff);*/
		/*
		if (laststar_x < nearstar_x - idscale || laststar_x > nearstar_x + idscale)
			goto notpartofthissystem;
		if (laststar_y < nearstar_y - idscale || laststar_y > nearstar_y + idscale)
			goto notpartofthissystem;
		if (laststar_z < nearstar_z - idscale || laststar_z > nearstar_z + idscale)
			goto notpartofthissystem;
		ap_target_x = laststar_x;
		ap_target_y = laststar_y;
		ap_target_z = laststar_z;
		extract_ap_target_infos ();
		prepare_nearstar ();
		lseek (fh, 4, SEEK_SET);
		while (_read (fh, &object_id, 8) && _read (fh, &object_label, 24) == 24) {
			fp_object_check = fpart (object_id, object_label);
			if (memcmp (&object_id, "Removed:", 8) && fp_object_check == fp_star_check && object_id > star_id + 1 - idscale && object_id <= star_id + MAX_OBJECTS_PER_STAR + idscale) {
			if (!memcmp (object_label, subjectname, strlen(subjectname))) {
				planet_nr  = object_label[23] - '0';
				planet_nr += 10 * (object_label[22] - '0');
				ch = _creat (comm, 0);
				if (ch > -1) {
					_write (ch, &planet_nr, 2);
					_close (ch);
					msg ("LOC. TARGET DATA SENT");
					msg ("BEGIN IN-SYSTEM DRIVE");
				}
				else
					msg ("COMMUNICATION ERROR.");
				return;
			}}
		}
	    notpartofthissystem:
		msg ("PLANET NOT FOUND AS");
		msg ("PART OF THIS SYSTEM.");
		sprintf (textbuffer, "PLEASE USE %cPAR%c TO", 34, 34);
		msg (textbuffer);
		msg ("FIND PARSIS FOR THE");
		msg ("CORRESPONDING STAR.");
		*/
	}
}


void main ()
{
	CHECK_SITUATION;
	/*asm {	xor	ax, ax
		mov	es, ax
		cmp	byte ptr es:[0x449], 0x13
		je	startup }

	printf ("\nGalactic Organization of Explorers and Stardrifters (G.O.E.S)\n");
	printf ("-------------------------------------------------------------\n");
	printf ("This is a GOES NET module and must be run from a stardrifter.\n");
	printf ("Please use the onboard computer console to run this module.\n");
	printf ("\n\t- GOES NET onboard microsystem, EPOC 6011 REVISION 2\n");
	return;*/

	//startup:
	if (_argc<2) {
		msg ("________USAGE________");
		msg ("ST OBJECTNAME");
		msg ("ST OBJECTNAME:RANGE");
		msg ("^^^^^^^^^^^^^^^^^^^^^");
		msg ("PLEASE RUN AGAIN,");
		msg ("SPECIFYING PARAMETERS");
		msg (divider);
		msg ("(ST REVISION 6011/27)");
		return;
	}
	else {
		msg ("LOOKING FOR TARGET...");
		msg (divider);
	}
	char *curfile = file;
	#ifdef GALAXY2
	msg ("WST NOT ST");
	ReadCurrentGalaxy();
	char real_current_galaxy = current_galaxy;
	fprintf(stderr, "We are in galaxy %i.\n", real_current_galaxy);
	for (current_galaxy=0; current_galaxy<2; current_galaxy++) {
		if (current_galaxy==1) {
			curfile = file2;
			//guide = guide2;
		}
		fprintf(stderr, "Scanning galaxy %i from file %s.\n", current_galaxy, file);
	#else
		msg ("ST NOT WST");
	
	#endif
	
	fprintf(stderr, "fh is %li\n", (long int)fh);
	fh = NULL;
	fh = fopen (curfile, "rb");
	fprintf(stderr, "fh is now %li\n", (long int)fh);
	if (fh == NULL) {
		msg ("STARMAP NOT AVAILABLE");
		return;
	}
	Udword starmap3Len = 0;
	fseek(fh, 0, SEEK_END);
	starmap3Len = ftell(fh);
	fprintf(stderr, "SM3Len on %s is %lu\n", curfile, starmap3Len);
	fseek(fh, 0, SEEK_SET);
	Uword fileFormatVersion;
	Udword starmap3VersionHalf;
	fread(&fileFormatVersion, 2, 1, fh);
	fread(&starmap3VersionHalf, 4, 1, fh);
	fread(&starmap3VersionHalf, 4, 1, fh);
	
	i = 2;
	strcpy (parbuffer, _argv[1]);
	while (i < _argc) {
		strcat (parbuffer, " ");
		strcat (parbuffer, _argv[i]);
		i++;
	}

	i = 0;
	while (parbuffer[i]) {
		if (parbuffer[i] == '_')
			parbuffer[i] = 32;
		i++;
	}

	i = 0;
	while (i < 21 && parbuffer[i] != ':' && parbuffer[i] != 0) {
		objectname[i] = parbuffer[i];
		i++;
	}

	if (parbuffer[i] != ':')
		analyzed_sectors_range = 100;
	else {
		sts = atoi (parbuffer + i + 1);
		if (sts <= 2 || sts > 10000)
			analyzed_sectors_range = 100;
		else
			analyzed_sectors_range = sts;
	}

	unfreeze ();
	if (sts > 100) warnMsg ("SCANNING THE GALAXY", -1);

	strupr (parbuffer);
	strupr (objectname);
	objectname[i] = 0;
	Dword matches = FindInStarmap (fh, starmap3Len, objectname, &sm3data);
	if (matches==1) {
		if (sm3data.retvalType==RETVAL_STAR) msg ("SUBJECT: STAR;");
		if (sm3data.retvalType==RETVAL_PLANET) msg ("SUBJECT: PLANET;");
		sprintf (outbuffer, "NAME: %s", sm3data.name);
		msg (outbuffer);
		msg ("_____________________");
		#ifdef GALAXY2
		fprintf(stderr, "Found it in galaxy %i. We are in galaxy %i.\n", current_galaxy, real_current_galaxy);
		if (current_galaxy==real_current_galaxy) {
			settarget ();
		} else {
			msg("NOT IN THIS GALAXY");
		}
		#else
		settarget ();
		#endif
	}

	fclose (fh);
	#ifdef GALAXY2
	}
	#endif
}