/*

	Noctis galactic map / DL command.
	GOES Net Module.

	Modified Apr 19-21 2005 by SL: Updated for starmap3.
	Changed to use modshare Feb 20 2005 by SL.
	Modified Feb 13 2005 by SL to fix possible bug due to use of align_m and align_e, now uses start_y and start_z instead.

	Description from the manual:
		DL [ObjectName][:Range]
		
		The parameter "ObjectName" can be either a star or a planet. If a star, DL will return a list of all the planets and moons of the star you refer to. If a planet, it will only list the moons of that planet. Bear in mind that parameters are always separated by a colon! If called with no parameters, DL gives a dependencies listing of the current system. Example:
		
		DL Fenia
		
		or
		
		DL Fenia:150

*/

const double MAX_OBJECTS_PER_STAR = 80;

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <dos.h>
#include <io.h>
#include "defs.h"
#include "modshare.hpp"

//////////////////////////////////////////////////////////////////////////////
Uchar flags;
Udword discoverer;
char name[21];
char lastname[21];
Dword sx, sy, sz;
Uword data;
Udword nextAlternateFP;
Udword starFP;

char   *situation_file  = "..\\DATA\\Current.BIN";

char   sync               = 1;		// 0
char   anti_rad           = 1;          // 1
char   pl_search          = 0;          // 2
char   field_amplificator = 0;          // 3
char   ilight             = 63;         // 4
char   ilightv            = 1;          // 5
char   charge             = 3;          // 6
char   revcontrols        = 0;          // 7
char   ap_targetting      = 0;          // 8
char   ap_targetted       = 0;          // 9
char   ip_targetting      = 0;          // 10
char   ip_targetted       = -1;		// 11
char   ip_reaching        = 0;          // 12
char   ip_reached         = 0;          // 13
char   ap_target_spin     = 0;          // 14
char   ap_target_r        = 0;          // 15
char   ap_target_g        = 0;          // 16
char   ap_target_b        = 0;          // 17
char   nearstar_spin      = 0;          // 18
char   nearstar_r         = 0;          // 19
char   nearstar_g         = 0;          // 20
char   nearstar_b         = 0;          // 21
char   gburst	          = 0;          // 22
char   menusalwayson      = 1;		// 23
char   depolarize  	  = 0;          // 24
Word    sys                = 4;		// 25
Word    pwr                = 15000;	// 27
Word    dev_page           = 0;		// 29
Word    ap_target_class    = 0;		// 31
Word    f_ray_elapsed	  = 0;		// 33
Word    nearstar_class     = 0;		// 35
Word    nearstar_nop       = 0;		// 37
float  pos_x              = 0;		// 39
float  pos_y              = 0;		// 43
float  pos_z              = -500;	// 47
float  user_alfa          = 0;		// 51
float  user_beta          = 0;		// 55
float  navigation_beta    = 0;		// 59
float  ap_target_ray      = 0;		// 63
float  nearstar_ray       = 1000;	// 67
double dzat_x             = +3797120;
double dzat_y             = -4352112;
double dzat_z             = -925018;
double ap_target_x        = 0;
double ap_target_y        = 1E9;
double ap_target_z        = 0;
double nearstar_x         = 0;
double nearstar_y         = 1E9;
double nearstar_z         = 0;
double helptime           = 0;
double ip_target_initial_d= 0;
double requested_approach_coefficient = 1;
double current_approach_coefficient = 1;
double reaction_time      = 0.01;
char   fcs_status[11]     = "STANDBY";
Word    fcs_status_delay   = 0;
Word    psys               = 4;
double ap_target_initial_d= 0;
double requested_vimana_coefficient = 1;
double current_vimana_coefficient = 1;
double vimana_reaction_time = 0.01;
char   lithium_collector  = 0;
char   autoscreenoff	  = 0;
char   ap_reached         = 0;
Word    lifter		  = 0;
double secs		  = 0;
Dword nearstar_sx	  	= 0x7fffffff;		//53
Dword nearstar_sy	  	= 0x7fffffff;		//57
Dword nearstar_sz	  	= 0x7fffffff;		//61
Uword obj_pNum;
Uword obj_mNum;
#define new_data_start 245+5+120

void unfreeze ()
{
	FILE * fh = fopen (situation_file, "rb");
	if (fh!=NULL) {
		fread (&sync, 244, 1, fh);
		fseek(fh, new_data_start+53, SEEK_SET);
		fread (&nearstar_sx, 12, 1, fh);
		fclose (fh);
	}
}

double 	object_id = 12345;
char   	object_label[25];

double 	s_object_id = 12345;
char   	s_object_label[25];
double 	mblock_id = 12345;
char   	mblock_message[77];

double	subject_id = 12345;
double  idscale = 0.00001;

Word	sts;
char	query;

Dword	round;
Word 	i;
FILE *fh;
FILE *gh;
Word 	analyzed_sectors_range;
char	*file = "..\\DATA\\starmap3.map";
char	*guide = "..\\DATA\\starmap3.gd";

char	outbuffer[40];
char	textbuffer[40];
char	parbuffer[160];
char	nullbuffer[128];
char	objectname[21];
char	subjectname[21];
Udword objectfp = 0;

char find (char *starname, Udword starmap3Len)
{
	Word p, n, ctc, found;
	ctc = strlen (starname);
	if (ctc > 20 || ctc <= 0) {
		msg ("INVALID OBJECT NAME.");
		return(0);
	}
	n = 0;
	found = 0;
	fseek (fh, 10, SEEK_SET);
	while (ftell(fh)<starmap3Len) {
		fread(&flags, 1, 1, fh);
		fread(&discoverer, 4, 1, fh);
		fread(&name, 20, 1, fh);
		if (flags&0x8) {
			fread(&sx, 4, 1, fh);
			fread(&sy, 4, 1, fh);
			fread(&sz, 4, 1, fh);
			fread(&data, 2, 1, fh);
			fread(&nextAlternateFP, 4, 1, fh);
			if (memcmp(name, starname, ctc)==0 && !(flags&0x20)) {
				//found it
				if (n==1) {	//If this is the second match
					msg ("AMBIGUOUS SEARCH KEY:");
					msg ("PLEASE EXPAND NAME...");
					msg (divider);
					msg ("POSSIBLE RESULTS ARE:");
					msg (divider);
					lastname[20]=0;
					msg (object_label);
				}
				if (n>0) {
					msg (name);
				}
				n++;
				memcpy(object_label, name, 20);
				memcpy(subjectname, object_label, 20);
				nearstar_sx = sx;
				nearstar_sy = sy;
				nearstar_sz = sz;
				obj_pNum=0x1F;
				obj_mNum=0x1F;
				found=1;
				while (p >= 0) {
					if (name[p] != 32) {
						if (name[p] == starname[p])
							return (found);
						else
							break;
					}
					p--;
				}
			}
		} else {
			fread(&starFP, 4, 1, fh);
			fread(&data, 2, 1, fh);
			fread(&nextAlternateFP, 4, 1, fh);
			if (memcmp(name, starname, ctc)==0 && !(flags&0x20)) {
				//found it
				if (n==1) {	//If this is the second match
					msg ("AMBIGUOUS SEARCH KEY:");
					msg ("PLEASE EXPAND NAME...");
					msg (divider);
					msg ("POSSIBLE RESULTS ARE:");
					msg (divider);
					lastname[20]=0;
					msg (object_label);
				}
				if (n>0) {
					msg (name);
				}
				n++;
				memcpy(object_label, name, 20);
				memcpy(subjectname, object_label, 20);
				
				Dword pos = ftell(fh);
				fseek(fh, starFP+25, SEEK_SET);
				fread(&nearstar_sx, 4, 1, fh);
				fread(&nearstar_sy, 4, 1, fh);
				fread(&nearstar_sz, 4, 1, fh);
				fseek(fh, pos, SEEK_SET);
				
				obj_pNum = ((data>>4)&0x1F);
				obj_mNum = ((data>>9)&0x1F);
				found=2;
				 while (p >= 0) {
					if (name[p] != 32) {
						if (name[p] == starname[p])
							return (found);
						else
							break;
					}
					p--;
				}
			}
		}
	}
	
	if (!n)
		msg ("OBJECT NOT FOUND.");
	if (n > 1) {
		found=0;
	}
	return (found);
}

//////////////////////////////////////////////////////////////////////////////

const double deg = M_PI / 180;

#define qt_M_PI   4*M_PI/3

#define star_classes    12
#define planet_types    10
#define avgmoons        4
#define log2avgmoons	2
#define maxbodies	20 * avgmoons

char class_rgb[3*star_classes] = {
	63, 58, 40,
	30, 50, 63,
	63, 63, 63,
	63, 30, 20,
	63, 55, 32,
	32, 16, 10,
	32, 28, 24,
	10, 20, 63,
	63, 32, 16,
	48, 32, 63,
	40, 10, 10,
	00, 63, 63
};

Word class_ray[star_classes] = { 5000, 15000, 300, 20000, 15000, 1000, 3000,
				2000, 4000, 1500, 30000, 250 };

Word class_rayvar[star_classes] = { 2000, 10000, 200, 15000, 5000, 1000, 3000,
				   500, 5000, 10000, 1000, 10 };

Word class_act[star_classes] = { 2, 4, 1, 6, 5, 10, 100, 1, 2, 1, 10, 1 };

char class_planets[star_classes] = { 12, 18, 8, 15, 20, 3, 0, 1, 7, 20, 2, 5 };

char   nearstar_p_type       [maxbodies];
Word    nearstar_p_owner	     [maxbodies];
char   nearstar_p_moonid     [maxbodies];
double nearstar_p_ring       [maxbodies];
double nearstar_p_tilt       [maxbodies];
double nearstar_p_ray        [maxbodies];
double nearstar_p_orb_ray    [maxbodies];
double nearstar_p_orb_seed   [maxbodies];
double nearstar_p_orb_tilt   [maxbodies];
double nearstar_p_orb_orient [maxbodies];
double nearstar_p_orb_ecc    [maxbodies];

Word planet_possiblemoons[] = { 1, 1, 2, 3, 2, 2, 18, 2, 3, 20, 20 };

const double planet_orb_scaling=  5.0;
const double avg_planet_sizing =  2.4;
const double moon_orb_scaling  = 12.8;
const double avg_moon_sizing   =  1.8;

double avg_planet_ray[] = { 0.007, 0.003, 0.010, 0.011, 0.010,
			    0.008, 0.064, 0.009, 0.012, 0.125,
			    2.000 };

double laststar_x, laststar_y, laststar_z;
float  zrandom (Word range) { return (random(range) - random(range)); }
double nearstar_identity;
Word    nearstar_nob;

/*char isthere (double star_id)
{
	char warnbuffer[41];

	double laststar_id;

	double sidlow = star_id - idscale;
	double sidhigh = star_id + idscale;

	unsigned sx, sy, sz;

	unsigned visible_sectors_x = analyzed_sectors_range;
	unsigned visible_sectors_y = analyzed_sectors_range;
	unsigned visible_sectors_z = analyzed_sectors_range;

	long   	advance = 100000;
	long   	sect_x, sect_y, sect_z;

	//long   	align_m = 100000 * visible_sectors_z;
	//long   	align_e = 100000 * visible_sectors_y;

	sect_x = (dzat_x - visible_sectors_x*50000) / 100000; sect_x *= 100000;
	sect_y = (dzat_y - visible_sectors_y*50000) / 100000; sect_y *= 100000;
	sect_z = (dzat_z - visible_sectors_z*50000) / 100000; sect_z *= 100000;

	long start_y = sect_y;
	long start_z = sect_z;
	
	asm {	mov ax, visible_sectors_x
		mov sx, ax }
e_while:asm {	mov ax, visible_sectors_y
		mov sy, ax }
m_while:asm {	mov ax, visible_sectors_z
		mov sz, ax }
i_while:asm {	db 0x66, 0xBB, 0x50, 0xC3, 0x00, 0x00 // mov ebx, 50000
		db 0x66; mov ax, word ptr sect_x
		db 0x66; mov dx, word ptr sect_z
		db 0x66; add ax, dx
		db 0x66; mov cx, ax
		db 0x66; mov dx, ax
		db 0x66, 0x81, 0xE2, 0xFF, 0xFF, 0x01, 0x00 // and edx, 0x0001FFFF
		db 0x66; add dx, word ptr sect_x
		db 0x66; sub dx, bx
		db 0x66; mov word ptr laststar_x, dx
		db 0x66; imul dx
		db 0x66; add dx, ax
		db 0x66; add cx, dx
		db 0x66, 0x81, 0xE2, 0xFF, 0xFF, 0x01, 0x00 // and edx, 0x0001FFFF
		db 0x66; add dx, word ptr sect_y
		db 0x66; sub dx, bx
		db 0x66; mov word ptr laststar_y, dx
		db 0x66; mov ax, cx
		db 0x66; imul dx
		db 0x66; add dx, ax
		db 0x66, 0x81, 0xE2, 0xFF, 0xFF, 0x01, 0x00 // and edx, 0x0001FFFF
		db 0x66; add dx, word ptr sect_z
		db 0x66; sub dx, bx
		db 0x66; mov word ptr laststar_z, dx
		fild dword ptr laststar_x
		fst  laststar_x
		fmul idscale
		fild dword ptr laststar_y
		fst  laststar_y
		fmul idscale
		fild dword ptr laststar_z
		fst  laststar_z
		fmul idscale
		fmulp
		fmulp
		fst laststar_id
		fcomp sidlow
		fstsw ax
		sahf
		jb i_next
		fld laststar_id
		fcomp sidhigh
		fstsw ax
		sahf
		jb y_end }
i_next:	asm {	db 0x66; mov ax, word ptr advance
		db 0x66; add word ptr sect_z, ax
		dec sz
		jz i_end
		jmp i_while }
i_end:	  asm { db 0x66; mov dx, word ptr start_z
		db 0x66; mov word ptr sect_z, dx
		db 0x66; add word ptr sect_y, ax
		dec sy
		jz m_end
		jmp m_while }
m_end:	  asm { db 0x66; mov dx, word ptr start_y
		db 0x66; mov word ptr sect_y, dx
		db 0x66; add word ptr sect_x, ax
		dec sx
		jz e_end
		db 0x66; pusha }
		if (sts > 100) {
			sprintf (warnbuffer, "SLICE %d OF %d", visible_sectors_x - sx, visible_sectors_x);
			warn (warnbuffer, 0);
			while (kbhit()) {
				if (getch() == 27) {
					asm { db 0x66; popa }
					return (0);
				}
			}
		}
	  asm { db 0x66; popa
		jmp e_while }
e_end:	  return (0);
y_end:	  return (1);
}*/

void extract_ap_target_infos ()
{
	srand (ap_target_x/100000*ap_target_y/100000*ap_target_z/100000);

	ap_target_class = random (star_classes);
	ap_target_ray = ((float)class_ray[ap_target_class] + (float)random(class_rayvar[ap_target_class])) * 0.001;

	ap_target_r = class_rgb[3*ap_target_class+0];
	ap_target_g = class_rgb[3*ap_target_class+1];
	ap_target_b = class_rgb[3*ap_target_class+2];

	ap_target_spin = 0;
	if (ap_target_class==11) ap_target_spin = random (30) + 1;
	if (ap_target_class==7) ap_target_spin = random (12) + 1;
	if (ap_target_class==2) ap_target_spin = random (4) + 1;
}

void prepare_nearstar ()
{
	Word    n, c, q, r, s, t;
	double key_radius;

	nearstar_class = ap_target_class;
	nearstar_x = ap_target_x;
	nearstar_y = ap_target_y;
	nearstar_z = ap_target_z;
	nearstar_ray = ap_target_ray;
	nearstar_spin = ap_target_spin;
	nearstar_r = ap_target_r;
	nearstar_g = ap_target_g;
	nearstar_b = ap_target_b;

	nearstar_identity = nearstar_x/100000*nearstar_y/100000*nearstar_z/100000;

	srand ((Dword)nearstar_x%10000*(Dword)nearstar_y%10000*(Dword)nearstar_z%10000);

	nearstar_nop = random (class_planets[nearstar_class] + 1);

	for (n=0; n<nearstar_nop; n++) {
		nearstar_p_owner[n]	 = -1;
		nearstar_p_orb_orient[n] = (double) deg * (double) random (360);
		nearstar_p_orb_seed[n]   = 3 * (n*n+1) * nearstar_ray + (float) random (300 * nearstar_ray) / 100;
		nearstar_p_tilt[n]       = zrandom (10*nearstar_p_orb_seed[n]) / 500;
		nearstar_p_orb_tilt[n]   = zrandom (10*nearstar_p_orb_seed[n]) / 5000;
		nearstar_p_orb_ecc[n]    = 1 - (double) random (nearstar_p_orb_seed[n] + 10*fabs(nearstar_p_orb_tilt[n])) / 2000;
		nearstar_p_ray[n]        = (double) random (nearstar_p_orb_seed[n]) * 0.001 + 0.01;
		nearstar_p_ring[n]	 = zrandom (nearstar_p_ray[n]) * (1 + (double) random (1000) / 100);
		if (nearstar_class != 8)
			nearstar_p_type[n] = random (planet_types);
		else {
			if (random(2)) {
				nearstar_p_type[n] = 10;
				nearstar_p_orb_tilt[n] *= 100;
			}
			else
				nearstar_p_type[n] = random (planet_types);
		}
		if (nearstar_class==2||nearstar_class==7||nearstar_class==15)
			nearstar_p_orb_seed[n] *= 10;
	}

	if (!nearstar_class) {
		if (random(4)==2) nearstar_p_type[2] = 3;
		if (random(4)==2) nearstar_p_type[3] = 3;
		if (random(4)==2) nearstar_p_type[4] = 3;
	}

	for (n=0; n<nearstar_nop; n++) {
		switch (nearstar_class) {
			case 2: while (nearstar_p_type[n]==3)
					nearstar_p_type[n] = random (10);
				break;
			case 5: while (nearstar_p_type[n]==6||
				       nearstar_p_type[n]==9)
					nearstar_p_type[n] = random (10);
				break;
			case 7:	nearstar_p_type[n] = 9;
				break;
			case 9: while (nearstar_p_type[n]!=0&&
				       nearstar_p_type[n]!=6&&
				       nearstar_p_type[n]!=9)
					nearstar_p_type[n] = random (10);
				break;
			case 11:while (nearstar_p_type[n]!=1&&
				       nearstar_p_type[n]!=7)
					nearstar_p_type[n] = random (10);
		}
	}

	for (n=0; n<nearstar_nop; n++) {
		switch (nearstar_p_type[n]) {
			case 0:
				if (random(8))
					nearstar_p_type[n] ++;
				break;
			case 3:
				if ((n<2)||(n>6)||(nearstar_class&&random(4))) {
					if (random(2))
						nearstar_p_type[n]++;
					else
						nearstar_p_type[n]--;
				}
				break;
			case 7:
				if (n<7) {
					if (random(2))
						nearstar_p_type[n] --;
					else
						nearstar_p_type[n] -= 2;
				}
				break;
		}
	}

	nearstar_nob = nearstar_nop;

	if (nearstar_class==2||nearstar_class==7||nearstar_class==15)
		goto no_moons;

	for (n=0; n<nearstar_nop; n++) {
		// (t=) Numero di satelliti per pianeta.
		s = nearstar_p_type[n];
		if (n < 2) {
			t = 0;
			if (s == 10)
				t = random (3);
		}
		else
			t = random (planet_possiblemoons[s] + 1);
		if (nearstar_nob + t > maxbodies)
			t = maxbodies - nearstar_nob;
		for (c=0; c<t; c++) {
			q 			 = nearstar_nob + c;
			nearstar_p_owner[q]	 = n;
			nearstar_p_moonid[q]	 = c;
			nearstar_p_orb_orient[q] = (double) deg * (double) random (360);
			nearstar_p_orb_seed[q]   = (c*c+4) * nearstar_p_ray[n] + (float) zrandom (300 * nearstar_p_ray[n]) / 100;
			nearstar_p_tilt[q]       = zrandom (10*nearstar_p_orb_seed[q]) / 50;
			nearstar_p_orb_tilt[q]   = zrandom (10*nearstar_p_orb_seed[q]) / 500;
			nearstar_p_orb_ecc[q]    = 1 - (double) random (nearstar_p_orb_seed[q] + 10*fabs(nearstar_p_orb_tilt[q])) / 2000;
			nearstar_p_ray[q]        = (double) random (nearstar_p_orb_seed[n]) * 0.05 + 0.1;
			nearstar_p_ring[q]	 = 0;
			nearstar_p_type[q]       = random (planet_types);
			r = nearstar_p_type[q];
			if (r==9 && s != 10) r = 2;
			if (r==6 && s < 9) r = 5;
			if (n > 7 && random(c)) r = 7;
			if (n > 9 && random(c)) r = 7;
			if (r==2 || r==3 || r==4 || r==8) {
				if (s != 6 && s < 9)
					r = 1;
			}
			if (r==3 && s < 9) {
				if (n > 7)
					r = 7;
				if (nearstar_class && random(4))
					r = 5;
				if (nearstar_class == 2 ||
				    nearstar_class == 7 ||
				    nearstar_class == 11)
					r = 8;
			}
			if (r==7 && n <= 5) r = 1;
			if ((nearstar_class==2||nearstar_class==5||
			     nearstar_class==7||nearstar_class==11)
			     && random(n)) r = 7;
			nearstar_p_type[q] = r;
		}
		nearstar_nob += t;
	}

no_moons:
	key_radius = nearstar_ray * planet_orb_scaling;
	if (nearstar_class == 8) key_radius *= 2;
	if (nearstar_class == 2) key_radius *= 16;
	if (nearstar_class == 7) key_radius *= 18;
	if (nearstar_class == 11) key_radius *= 20;
	for (n=0; n<nearstar_nop; n++) {
		nearstar_p_ray[n] = avg_planet_ray[nearstar_p_type[n]]
				  + avg_planet_ray[nearstar_p_type[n]] * zrandom (100) / 200;
		nearstar_p_ray[n] *= avg_planet_sizing;
		nearstar_p_orb_ray[n] = key_radius + key_radius * zrandom (100) / 500;
		nearstar_p_orb_ray[n] += key_radius * avg_planet_ray[nearstar_p_type[n]];
		if (n < 8)
			key_radius += nearstar_p_orb_ray[n];
		else
			key_radius += 0.22 * nearstar_p_orb_ray[n];
	}

	n = nearstar_nop;
	while (n < nearstar_nob) {
		q = 0;
		c = nearstar_p_owner[n];
		key_radius = nearstar_p_ray[c] * moon_orb_scaling;
		while (n<nearstar_nob && nearstar_p_owner[n] == c) {
			nearstar_p_ray[n] = avg_planet_ray[nearstar_p_type[n]]
					  + avg_planet_ray[nearstar_p_type[n]] * zrandom (100) / 200;
			nearstar_p_ray[n] *= avg_moon_sizing;
			nearstar_p_orb_ray[n] = key_radius + key_radius * zrandom (100) / 250;
			nearstar_p_orb_ray[n] += key_radius * avg_planet_ray[nearstar_p_type[n]];
			if (q < 2) key_radius += nearstar_p_orb_ray[n];
			if (q >= 2 && q < 8) key_radius += 0.12 * nearstar_p_orb_ray[n];
			if (q >= 8) key_radius += 0.025 * nearstar_p_orb_ray[n];
			q++;
			n++;
		}
	}

	for (n = 0; n < nearstar_nop; n++) {
		nearstar_p_ring[n] = 0.75 * nearstar_p_ray[n] * (2 + random(3));
		s = nearstar_p_type[n];
		if (s != 6 && s != 9) {
			if (random(5))
				nearstar_p_ring[n] = 0;
		}
		else {
			if (random(2))
				nearstar_p_ring[n] = 0;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////

Dword labposit[80];
char labprogr[80];

Dword labposit2[80];
char labprogr2[80];
Uword labdata[80];

Dword fpart (double id, char *label)
{
	Dword	fpart, no;
	Word	attempts = 0;
	double	multiplier = 1E9;

	if (label[21] == 'P') {
		no  = label[23] - '0';
		no += 10 * (label[22] - '0');
		id -= no;
	}

	id = fabs(id);

	do {
		fpart = multiplier * ((double)id - (Dword)id);
		multiplier *= 1000;
		attempts++;
	} while (fpart < 1E6 && attempts < 44);

	return (fpart);
}

Dword notesabout (Uword pNum, Uword mNum)
{
	//This also checks nearstar_sx, nearstar_sy, and nearstar_sz
	Dword ncount = 0;
	if (gh == NULL) return (0);
	
	long guide3Len = 0;
	fseek(gh, 0, SEEK_END);
	guide3Len = ftell(gh);
	fseek(gh, 10, SEEK_SET);
	Uchar flags;
	Dword subjectsx, subjectsy, subjectsz, writer;
	Uword subject_pNum, subject_mNum;
	char entry[77];
	entry[76]=0;
	
	while (ftell(gh)<guide3Len) {
		fread(&flags, 1, 1, gh);
		fread(&subjectsx, 4, 1, gh);
		fread(&subjectsy, 4, 1, gh);
		fread(&subjectsz, 4, 1, gh);
		fread(&subject_pNum, 2, 1, gh);
		fread(&subject_mNum, 2, 1, gh);
		fread(&writer, 4, 1, gh);
		fread(&entry, 76, 1, gh);
		if (!(flags&0x20)) { //0x20 = deleted
			if (subjectsx==nearstar_sx && subjectsy==nearstar_sy && subjectsz==nearstar_sz && pNum==subject_pNum && mNum==subject_mNum) {
				ncount++;
			}
		}
	}
	/*
	For each entry:
		Uchar flags;	//bit 7 is 'include in outbox', bit 6 is 'local only'. bit 5 is 'deleted'. The other bits aren't used at this time.
		Dword subjectsx;
		Dword subjectsy;
		Dword subjectsz;
		Udword writer;	//the person who wrote the entry
		char entry[76];
	*/
	/*lseek (gh, 4, SEEK_SET);
	while (_read (gh, &mblock_id, 8) && _read (gh, &mblock_message, 76) == 76) {
		if (memcmp (&mblock_id, "Removed:", 8)) {
			if (mblock_id >= id - idscale && mblock_id <= id + idscale)
				ncount++;
		}
	}*/

	return (ncount);
}


void listplanets ()
{
	Word	n, n2, b1, b2, b3;
	Dword	b4, ncount;

	Word 	planet_nr, pcount, bcount;
	Word	planet_id, mcount;

	char 	least = 0;

	/*double 	star_id;
	Dword	fp_star_check;
	Dword	fp_object_check;

	if (query == 2) {
		planet_nr  = object_label[23] - '0';
		planet_nr += 10 * (object_label[22] - '0');
		star_id    = object_id - planet_nr;
	}
	else
		star_id = object_id;

	if (!isthere2 (star_id, analyzed_sectors_range, dzat_x, dzat_y, dzat_z, sts>100)) {
		msg (subjectname);
		msg ("IS OUT OF RANGE");
		return;
	}
	else
		fp_star_check = fpart (star_id, "F-PARTTESTSTARLABEL Sxx");
	*/
	
	warnMsg ("ORGANIZING TREE...", 1);
	PrepareFromSectorCoords(nearstar_sx, nearstar_sy, nearstar_sz);
	
	ap_target_x = foundstar_x;
	ap_target_y = foundstar_y;
	ap_target_z = foundstar_z;
	//ap_target_id = foundstar_id;
	extract_ap_target_infos ();
	prepare_nearstar ();

	sprintf (textbuffer, "*%s", sm3data.name);
	msg (textbuffer);

	if (sm3data.retvalType == 1) {	//star
		pcount = 0;
		mcount = 0;
		bcount = 0;
		long starmap3Len = 0;
		fseek(fh, 0, SEEK_END);
		starmap3Len = ftell(fh);
		fseek(fh, 0, SEEK_SET);
		fseek(fh, 10, SEEK_SET);
		Dword tgtStarFP=0;
		while (ftell(fh)<starmap3Len) {
			fread(&flags, 1, 1, fh);
			fread(&discoverer, 4, 1, fh);
			fread(&name, 20, 1, fh);
			if (flags&0x8) {
				fread(&sx, 4, 1, fh);
				fread(&sy, 4, 1, fh);
				fread(&sz, 4, 1, fh);
				fread(&data, 2, 1, fh);
				fread(&nextAlternateFP, 4, 1, fh);
				if (tgtStarFP==0) {
					if (memcmp(name, sm3data.name, 20)==0 && !(flags&0x20)) {
						tgtStarFP=ftell(fh)-43;
						fseek(fh, 10, SEEK_SET);
						ncount = notesabout(0x1F, 0x1F);
						if (ncount > 0) {
							sprintf (textbuffer, "]   (%ld NOTES)", ncount);
							msg (textbuffer);
						}
					}
				}
			} else {
				fread(&starFP, 4, 1, fh);
				fread(&data, 2, 1, fh);
				fread(&nextAlternateFP, 4, 1, fh);
				if (tgtStarFP!=0) {
					if (starFP==tgtStarFP) {
						//int data_pType = (data&0xF);	//Unused
						//int data_pNum = ((data>>4)&0x1F);	//Unused
						int data_mNum = ((data>>9)&0x1F);
						/*
						(data&0xF) (4b) => Planet type/class // Bits 0-3, valid values 0-10
						((data>>4)&0x1F) (5b) => Planet number //Bits 4-8, valid values 0-19	//If this object is a moon, this is the planet # of its parent, otherwise it's the planet's own ID#.
						((data>>9)&0x1F) (5b) => Moon number //Bits 9-13, valid values 0-19		//If this object is a planet, this is 0x1F (meaning not-a-moon). Otherwise it's the moon #.
						*/
						labposit[bcount] = ftell (fh) - 30;
						
						labdata[bcount] = data;
						if (data_mNum==0x1F) {	//This is a planet
							least = 1;
							pcount++;
						} else {
							mcount++;
						}
						bcount++;
						
					}
				} else if (tgtStarFP==0) {
					if (memcmp(name, sm3data.name, 20)==0 && !(flags&0x20)) {
						//int data_pType = (data&0xF);	//Unused 
						int data_pNum = ((data>>4)&0x1F);
						int data_mNum = ((data>>9)&0x1F);
						tgtStarFP=starFP;
						fseek(fh, 10, SEEK_SET);
						ncount = notesabout(data_pNum, data_mNum);
						if (ncount > 0) {
							sprintf (textbuffer, "]   (%ld NOTES)", ncount);
							msg (textbuffer);
						}
					}
				}
			}
		}
		/*lseek (fh, 4, SEEK_SET);
		while (_read (fh, &object_id, 8) && _read (fh, &object_label, 24) == 24) {
			fp_object_check = fpart (object_id, object_label);
			if (memcmp (&object_id, "Removed:", 8) && fp_object_check == fp_star_check && object_id > star_id + 1 - idscale && object_id <= star_id + MAX_OBJECTS_PER_STAR + idscale) {
			planet_nr  = object_label[23] - '0';
			planet_nr += 10 * (object_label[22] - '0');
			if (nearstar_p_owner[planet_nr - 1] == -1) {
				labposit[pcount] = tell (fh) - 32;
				labprogr[pcount] = planet_nr;
				least = 1;
				pcount++;
			}}
		}*/
		do {
			b1 = 0;
			b2 = 0;
			while (b2 < bcount - 1) {
				Uword data1 = labdata[b2];
				Uword data2 = labdata[b2+1];
				//int data1_pType = (data1&0xF);	//Unused
				int data1_pNum = ((data1>>4)&0x1F);
				int data1_mNum = ((data1>>9)&0x1F);
				//int data2_pType = (data2&0xF);	//Unused
				int data2_pNum = ((data2>>4)&0x1F);
				int data2_mNum = ((data2>>9)&0x1F);
						
				#define Swap b4 = labposit[b2];\
							labposit[b2] = labposit[b2+1];\
							labposit[b2+1] = b4;\
							b3 = labdata[b2];\
							labdata[b2] = labdata[b2+1];\
							labdata[b2+1] = b3;\
							b1 = 1
				//planets, then moons
				if (data1_mNum==0x1F) {	//It's a planet
					if (data2_mNum==0x1F) {	//It's a planet too
						if (data1_pNum>data2_pNum) {
							Swap;
						}
					} //If 2 isn't a planet, then it's supposed to go to the right, so we don't do anything
				} else {	//It's a moon
					if (data2_mNum==0x1F) {	//It's a planet
						Swap;
					} else {
						if (data1_pNum>data2_pNum) {
							Swap;
						} else if (data1_pNum==data2_pNum && data1_mNum>data2_mNum) {
							Swap;
						}
					}
				}
				/*if (labprogr[b2] > labprogr[b2+1]) {
					b4 = labposit[b2];
					labposit[b2] = labposit[b2+1];
					labposit[b2+1] = b4;
					b3 = labprogr[b2];
					labprogr[b2] = labprogr[b2+1];
					labprogr[b2+1] = b3;
					b1 = 1;
				}*/
				
				b2++;
			}
		} while (b1);
		n = 0;
		int last_pNum = -1;
		int last_mNum = -1;
		int final_entry = 0;
		for (int a=0; a<bcount; a++) {
			Uword data1 = labdata[a];
			int data1_pNum = ((data1>>4)&0x1F);
			int data1_mNum = ((data1>>9)&0x1F);
			final_entry = a;
			if (data1_mNum==0x1F) {
				if (last_pNum!=data1_pNum && a>0) {
					labdata[a-1] = labdata[a-1]|0x1;
					
				}
				last_pNum=data1_pNum;
				if (last_mNum!=0x1F) {
					labdata[a-1]=labdata[a-1]|0x1;
					last_mNum=0x1F;
				}				
			} else {
				if (a>0) {
					if (last_mNum!=data1_mNum) {
						labdata[a-1]=labdata[a-1]|0x1;
					}
				}
			}
			
			/*fseek (fh, labposit[a], SEEK_SET);
			fread (&object_label, 20, 1, fh);
			sprintf(textbuffer, "PN=%i MN=%i OL=%.20s", data1_pNum, data1_mNum, object_label);
			msg(textbuffer);*/
		}
		if (bcount>0) {
			labdata[final_entry]=labdata[final_entry]|0x1;
		}
		msg("--------");
		last_pNum = -1;
		while (pcount) {
			fseek (fh, labposit[n], SEEK_SET);
			fread (&object_label, 20, 1, fh);
			Uword data1 = labdata[n];
			//int data1_pType = (data1&0xF);	//Unused
			int data1_pNum = ((data1>>4)&0x1F);
			int data1_mNum = ((data1>>9)&0x1F);
			planet_nr = data1_pNum;
			//planet_nr  = object_label[23] - '0';
			//planet_nr += 10 * (object_label[22] - '0');
			pcount--;
			if (pcount) {
				if (last_pNum==planet_nr) {
					sprintf (textbuffer, "]AKA %s", object_label);
				} else {
					sprintf (textbuffer, "$%02d&%s", planet_nr+1, object_label);
				}
				msg (textbuffer);
				if (data1&0x1) {
					ncount = notesabout (data1_pNum, data1_mNum);
					if (ncount > 0) {
						sprintf (textbuffer, "]   (%ld NOTES)", ncount);
						msg (textbuffer);
					}
				}
			}
			else {
				if (last_pNum==planet_nr) {
					sprintf (textbuffer, "]AKA %s", object_label);
				} else {
					sprintf (textbuffer, "[%02d&%s", planet_nr+1, object_label);
				}
				msg (textbuffer);
				if (data1&0x1) {
					ncount = notesabout (data1_pNum, data1_mNum);
					if (ncount > 0) {
						sprintf (textbuffer, "    (%ld NOTES)", ncount);
						msg (textbuffer);
					}
				}
			}
			
			/*planet_id  = object_label[23] - '0';
			planet_id += 10 * (object_label[22] - '0');
			mcount = 0;
			lseek (fh, 4, SEEK_SET);
			while (_read (fh, &object_id, 8) && _read (fh, &object_label, 24) == 24) {
				fp_object_check = fpart (object_id, object_label);
				if (memcmp (&object_id, "Removed:", 8) && fp_object_check == fp_star_check && object_id > star_id + 1 - idscale && object_id <= star_id + MAX_OBJECTS_PER_STAR + idscale) {
				planet_nr  = object_label[23] - '0';
				planet_nr += 10 * (object_label[22] - '0');
				if (nearstar_p_owner[planet_nr - 1] == planet_id - 1) {
					labposit2[mcount] = tell (fh) - 32;
					labprogr2[mcount] = nearstar_p_moonid[planet_nr - 1];
					mcount++;
				}}
			}
			do {
				b1 = 0;
				b2 = 0;
				while (b2 < mcount - 1) {
					if (labprogr2[b2] > labprogr2[b2+1]) {
						b4 = labposit2[b2];
						labposit2[b2] = labposit2[b2+1];
						labposit2[b2+1] = b4;
						b3 = labprogr2[b2];
						labprogr2[b2] = labprogr2[b2+1];
						labprogr2[b2+1] = b3;
						b1 = 1;
					}
					b2++;
				}
			} while (b1);*/
			if (data1&0x1) {
				n2 = 0;
				Word mcountbak = mcount;
				mcount=0;
				for (int a=0; a<bcount; a++) {
					Uword data2 = labdata[a];
					//int data2_pType = (data2&0xF);	//Unused
					int data2_pNum = ((data2>>4)&0x1F);
					int data2_mNum = ((data2>>9)&0x1F);
					if (data2_pNum==data1_pNum && data2_mNum!=0x1F) {
						mcount++;
					}
				}
				last_mNum = -1;
				while (mcount) {
					Uword data2 = labdata[n2];
					//int data2_pType = (data2&0xF);	//Unused
					int data2_pNum = ((data2>>4)&0x1F);
					int data2_mNum = ((data2>>9)&0x1F);
					if (data2_pNum==data1_pNum && data2_mNum!=0x1F) {
						fseek (fh, labposit[n2], SEEK_SET);
						fread (&object_label, 20, 1, fh);
						mcount--;
						if (pcount) {
							if (mcount) {
								if (last_mNum==data2_mNum) {
									sprintf (textbuffer, "] ]AKA %s", object_label);
								} else {
									sprintf (textbuffer, "] $%02d&%s", data2_mNum + 1, object_label);
								}
								msg (textbuffer);
								if (data2&0x1) {
									ncount = notesabout(data2_pNum, data2_mNum);
									if (ncount > 0) {
										sprintf (textbuffer, "] ]   (%ld NOTES)", ncount);
										msg (textbuffer);
									}
								}
							}
							else {
								if (last_mNum==data2_mNum) {
									sprintf (textbuffer, "] ]AKA %s", object_label);
								} else {
									sprintf (textbuffer, "] [%02d&%s", data2_mNum + 1, object_label);
								}
								msg (textbuffer);
								ncount = notesabout(data2_pNum, data2_mNum);
								if (data2&0x1) {
									if (ncount > 0) {
										sprintf (textbuffer, "]     (%ld NOTES)", ncount);
										msg (textbuffer);
									}
								}
							}
						}
						else {
							if (mcount) {
								if (last_mNum==data2_mNum) {
									sprintf (textbuffer, "  ]AKA %s", object_label);
								} else {
									sprintf (textbuffer, "  $%02d&%s", data2_mNum + 1, object_label);
								}
								msg (textbuffer);
								ncount = notesabout(data2_pNum, data2_mNum);
								if (data2&0x1) {
									if (ncount > 0) {
										sprintf (textbuffer, "  ]   (%ld NOTES)", ncount);
										msg (textbuffer);
									}
								}
							}
							else {
								if (last_mNum==data2_mNum) {
									sprintf (textbuffer, "  ]AKA %s", object_label);
								} else {
									sprintf (textbuffer, "  [%02d&%s", data2_mNum + 1, object_label);
								}
								msg (textbuffer);
								ncount = notesabout(data2_pNum, data2_mNum);
								if (data2&0x1) {
									if (ncount > 0) {
										sprintf (textbuffer, "      (%ld NOTES)", ncount);
										msg (textbuffer);
									}
								}
							}
						}
					}
					n2++;
				}
				mcount = mcountbak;
			}
			n++;
			last_pNum=planet_nr;
		}
		if (least) {
			msg (divider);
			msg ("PLANETS LISTING END.");
		}
		else
			msg ("NO KNOWN PLANETS.");
	}

	if (sm3data.retvalType==RETVAL_PLANET) {
		//planet_id  = object_label[23] - '0';
		//planet_id += 10 * (object_label[22] - '0');
		mcount = 0;
		long starmap3Len = 0;
		fseek(fh, 0, SEEK_END);
		starmap3Len = ftell(fh);
		fseek(fh, 0, SEEK_SET);
		fseek(fh, 10, SEEK_SET);
		Dword tgtStarFP=0;
		while (ftell(fh)<starmap3Len) {
			fread(&flags, 1, 1, fh);
			fread(&discoverer, 4, 1, fh);
			fread(&name, 20, 1, fh);
			if (flags&0x8) {
				fread(&sx, 4, 1, fh);
				fread(&sy, 4, 1, fh);
				fread(&sz, 4, 1, fh);
				fread(&data, 2, 1, fh);
				fread(&nextAlternateFP, 4, 1, fh);
				
			} else {
				fread(&starFP, 4, 1, fh);
				fread(&data, 2, 1, fh);
				fread(&nextAlternateFP, 4, 1, fh);
				if (tgtStarFP==0) {
					if (memcmp(name, sm3data.name, 20)==0 && !(flags&0x20)) {
						tgtStarFP=starFP;
						fseek(fh, 10, SEEK_SET);
					}
				} else {
					if (starFP==tgtStarFP) {
						//int data_pType = (data&0xF);	//Unused
						int data_pNum = ((data>>4)&0x1F);
						int data_mNum = ((data>>9)&0x1F);
						/*
						(data&0xF) (4b) => Planet type/class // Bits 0-3, valid values 0-10
						((data>>4)&0x1F) (5b) => Planet number //Bits 4-8, valid values 0-19	//If this object is a moon, this is the planet # of its parent, otherwise it's the planet's own ID#.
						((data>>9)&0x1F) (5b) => Moon number //Bits 9-13, valid values 0-19		//If this object is a planet, this is 0x1F (meaning not-a-moon). Otherwise it's the moon #.
						*/
						if (starFP==tgtStarFP && data_mNum!=0x1F && data_pNum==sm3data.pNum) {
							labposit[mcount] = ftell (fh) - 30;
						
							labdata[mcount] = data;
							least = 1;
							mcount++;
							
						}
						
					}
				}
			}
		}
		/*mcount = 0;
		lseek (fh, 4, SEEK_SET);
		while (_read (fh, &object_id, 8) && _read (fh, &object_label, 24) == 24) {
			fp_object_check = fpart (object_id, object_label);
			if (memcmp (&object_id, "Removed:", 8) && fp_object_check == fp_star_check && object_id > star_id + 1 - idscale && object_id <= star_id + MAX_OBJECTS_PER_STAR + idscale) {
			planet_nr  = object_label[23] - '0';
			planet_nr += 10 * (object_label[22] - '0');
			if (nearstar_p_owner[planet_nr - 1] == planet_id - 1) {
				labposit2[mcount] = tell (fh) - 32;
				labprogr2[mcount] = nearstar_p_moonid[planet_nr - 1];
				least = 1;
				mcount++;
			}}
		}*/
		do {
			b1 = 0;
			b2 = 0;
			while (b2 < mcount - 1) {
				if (labprogr2[b2] > labprogr2[b2+1]) {
					b4 = labposit2[b2];
					labposit2[b2] = labposit2[b2+1];
					labposit2[b2+1] = b4;
					b3 = labprogr2[b2];
					labprogr2[b2] = labprogr2[b2+1];
					labprogr2[b2+1] = b3;
					b1 = 1;
				}
				b2++;
			}
		} while (b1);
		n2 = 0;
		while (mcount) {
			Uword data2 = labdata[n2];
			//int data2_pType = (data2&0xF);	//Unused
			int data2_pNum = ((data2>>4)&0x1F);
			int data2_mNum = ((data2>>9)&0x1F);
			fseek (fh, labposit[n2], SEEK_SET);
			fread (&object_label, 20, 1, fh);
			mcount--;
			sprintf (textbuffer, "$%02d&%s", data2_mNum + 1, object_label);
			msg (textbuffer);
			ncount = notesabout(data2_pNum, data2_mNum);
			if (ncount > 0) {
				if (mcount) {
					sprintf (textbuffer, "]   (%ld NOTES)", ncount);
					msg (textbuffer);
				} else {
					sprintf (textbuffer, "    (%ld NOTES)", ncount);
					msg (textbuffer);
				}
			}
			n2++;
		}
		/*while (mcount) {
			lseek (fh, labposit2[n2], SEEK_SET);
			_read (fh, &object_id, 8);
			_read (fh, &object_label, 24);
			planet_nr  = object_label[23] - '0';
			planet_nr += 10 * (object_label[22] - '0');
			mcount--;
			if (mcount) {
				sprintf (textbuffer, "$%02d&%s", nearstar_p_moonid[planet_nr - 1] + 1, object_label);
				msg (textbuffer);
				ncount = notesabout (object_id);
				if (ncount > 0) {
					sprintf (textbuffer, "]   (%ld NOTES)", ncount);
					msg (textbuffer);
				}
			}
			else {
				sprintf (textbuffer, "[%02d&%s", nearstar_p_moonid[planet_nr - 1] + 1, object_label);
				msg (textbuffer);
				ncount = notesabout (object_id);
				if (ncount > 0) {
					sprintf (textbuffer, "    (%ld NOTES)", ncount);
					msg (textbuffer);
				}
			}
			n2++;
		}*/
		if (least) {
			msg (divider);
			msg ("MOONS LISTING END.");
		}
		else
			msg ("NO KNOWN MOONS.");
	}
}

//double ap_target_id = 12345;

void main ()
{
	/*asm {	xor	ax, ax
		mov	es, ax
		cmp	byte ptr es:[0x449], 0x13
		je	startup }

	printf ("\nGalactic Organization of Explorers and Stardrifters (G.O.E.S)\n");
	printf ("-------------------------------------------------------------\n");
	printf ("This is a GOES NET module and must be run from a stardrifter.\n");
	printf ("Please use the onboard computer console to run this module.\n");
	printf ("\n\t- GOES NET onboard microsystem, EPOC 6011 REVISION 2\n");
	return;*/

	startup:
	unfreeze ();
	if (_argc<2 && ap_targetted != 1) {
		msg ("________USAGE________");
		msg ("DL OBJECTNAME");
		msg ("DL OBJECTNAME:RANGE");
		msg ("^^^^^^^^^^^^^^^^^^^^^");
		msg ("PLEASE RUN AGAIN,");
		msg ("SPECIFYING PARAMETERS");
		msg (divider);
		msg ("(DL REVISION 6011/672)");
		return;
	}
	else {
		msg ("DEPENDENCIES LISTING:");
		msg (divider);
	}

	gh = fopen (guide, "rb");

	fh = fopen (file, "rb");
	if (fh == NULL) {
		msg ("STARMAP NOT AVAILABLE");
		return;
	}

	Udword starmap3Len = 0;
	fseek(fh, 0, SEEK_END);
	starmap3Len = ftell(fh);
	fseek(fh, 0, SEEK_SET);
	Uword fileFormatVersion;
	Udword starmap3VersionHalf;
	fread(&fileFormatVersion, 2, 1, fh);
	fread(&starmap3VersionHalf, 4, 1, fh);
	fread(&starmap3VersionHalf, 4, 1, fh);
	if (_argc<2) {
		
		while (ftell(fh)<starmap3Len) {
			fread(&flags, 1, 1, fh);
			fread(&discoverer, 4, 1, fh);
			fread(&name, 20, 1, fh);
			if (flags&0x8) {
				fread(&sx, 4, 1, fh);
				fread(&sy, 4, 1, fh);
				fread(&sz, 4, 1, fh);
				fread(&data, 2, 1, fh);
				fread(&nextAlternateFP, 4, 1, fh);
				if (sx==nearstar_sx && sy==nearstar_sy && sz==nearstar_sz) {
					//found it
					objectfp = ftell(fh);	//-43
					memcpy(objectname, name, 20);
					objectname[20]=0;
					goto no_arguments;
				}
			} else {
				fread(&starFP, 4, 1, fh);
				fread(&data, 2, 1, fh);
				fread(&nextAlternateFP, 4, 1, fh);
			}
		}
		fclose(fh);
		msg ("CURRENT REMOTE TARGET");
		msg ("CANNOT BE FOUND.");
		return;
	}

	i = 2;
	strcpy (parbuffer, _argv[1]);
	while (i < _argc) {
		strcat (parbuffer, " ");
		strcat (parbuffer, _argv[i]);
		i++;
	}

	i = 0;
	while (parbuffer[i]) {
		if (parbuffer[i] == '_')
			parbuffer[i] = 32;
		i++;
	}

	i = 0;
	while (i < 21 && parbuffer[i] != ':' && parbuffer[i] != 0) {
		objectname[i] = parbuffer[i];
		i++;
	}

	if (parbuffer[i] != ':')
		analyzed_sectors_range = 100;
	else {
		sts = atoi (parbuffer + i + 1);
		if (sts <= 2 || sts > 10000)
			analyzed_sectors_range = 100;
		else
			analyzed_sectors_range = sts;
	}

	if (sts > 100) warnMsg ("SCANNING THE GALAXY: ESC TO STOP", -1);

	strupr (parbuffer);
	strupr (objectname);
	objectname[i] = 0;

    no_arguments:
	Dword matches = FindInStarmap (fh, starmap3Len, objectname, &sm3data);
	if (matches==1) {
		msg ("TRANSFER SUCCEDED:");
		msg (divider);
		if (sm3data.retvalType==RETVAL_STAR) msg ("SUBJECT: STAR;");
		if (sm3data.retvalType==RETVAL_PLANET) msg ("SUBJECT: PLANET;");
		sprintf (outbuffer, "NAME: %s", sm3data.name);
		msg (outbuffer);
		msg ("_____________________");
		listplanets ();
	}

	if (gh != NULL) fclose (gh);
	fclose (fh);
}